/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.rsvp.objects.subobjects.IPv4AddressRROSubobject;
import es.tid.rsvp.objects.subobjects.IPv6AddressRROSubobject;
import es.tid.rsvp.objects.subobjects.RROSubobject;
import java.util.LinkedList;

public class ReportedRouteObject
extends PCEPObject {
    private LinkedList<RROSubobject> rroSubObjectList;

    public ReportedRouteObject() {
        this.setObjectClass(8);
        this.setOT(1);
        this.rroSubObjectList = new LinkedList();
    }

    public ReportedRouteObject(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 4;
        int k = 0;
        while (k < this.rroSubObjectList.size()) {
            this.rroSubObjectList.get(k).encode();
            len += this.rroSubObjectList.get(k).getRrosolength();
            ++k;
        }
        this.ObjectLength = len;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        int pos = 4;
        int k2 = 0;
        while (k2 < this.rroSubObjectList.size()) {
            System.arraycopy(this.rroSubObjectList.get(k2).getSubobject_bytes(), 0, this.object_bytes, pos, this.rroSubObjectList.get(k2).getRrosolength());
            pos += this.rroSubObjectList.get(k2).getRrosolength();
            ++k2;
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        this.rroSubObjectList = new LinkedList();
        boolean fin = false;
        int offset = 4;
        if (this.ObjectLength == 4) {
            fin = true;
        }
        while (!fin) {
            int subojectclass = RROSubobject.getType(this.getObject_bytes(), offset);
            int subojectlength = RROSubobject.getLength(this.getObject_bytes(), offset);
            switch (subojectclass) {
                case 1: {
                    IPv4AddressRROSubobject sobjt4 = new IPv4AddressRROSubobject(this.getObject_bytes(), offset);
                    this.rroSubObjectList.add(sobjt4);
                    break;
                }
                case 2: {
                    IPv6AddressRROSubobject sobjt6 = new IPv6AddressRROSubobject(this.getObject_bytes(), offset);
                    this.rroSubObjectList.add(sobjt6);
                    break;
                }
            }
            if ((offset += subojectlength) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public LinkedList<RROSubobject> getRroSubObjectList() {
        return this.rroSubObjectList;
    }

    public void setRroSubObjectList(LinkedList<RROSubobject> rroSubObjectList) {
        this.rroSubObjectList = rroSubObjectList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.rroSubObjectList == null ? 0 : this.rroSubObjectList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportedRouteObject other = (ReportedRouteObject)obj;
        return !(this.rroSubObjectList == null ? other.rroSubObjectList != null : !this.rroSubObjectList.equals(other.rroSubObjectList));
    }
}

