/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.PCEPElement;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PCEPObject
implements PCEPElement {
    protected int ObjectClass;
    protected int OT;
    protected int Res;
    protected boolean Pbit;
    protected boolean Ibit;
    protected int ObjectLength;
    protected byte[] object_bytes;
    protected static final Logger log = LoggerFactory.getLogger((String)"PCEPParser");

    public PCEPObject() {
        this.Res = 0;
        this.Pbit = false;
        this.Ibit = false;
    }

    public PCEPObject(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        this.ObjectLength = bytes[offset + 2] << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        this.object_bytes = new byte[this.ObjectLength];
        System.arraycopy(bytes, offset, this.object_bytes, 0, this.ObjectLength);
        this.decodeHeader();
    }

    @Override
    public abstract void encode();

    public abstract void decode() throws MalformedPCEPObjectException;

    public void decode(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        this.ObjectLength = bytes[offset + 2] << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        this.object_bytes = new byte[this.ObjectLength];
        System.arraycopy(bytes, offset, this.object_bytes, 0, this.ObjectLength);
        this.decodeHeader();
        this.decode();
    }

    public void encode_header() {
        this.object_bytes[0] = (byte)this.ObjectClass;
        this.object_bytes[1] = (byte)(this.OT << 4 & 0xF0 | this.Res << 2 & 0xC | (this.Pbit ? 1 : 0) << 1 & 2 | (this.Ibit ? 1 : 0));
        this.object_bytes[2] = (byte)(this.ObjectLength >> 8 & 0xFF);
        this.object_bytes[3] = (byte)(this.ObjectLength & 0xFF);
    }

    public void decodeHeader() {
        this.ObjectClass = this.object_bytes[0] & 0xFF;
        this.OT = this.object_bytes[1] >> 4 & 0xF;
        this.ObjectLength = this.object_bytes[2] << 8 & 0xFF00 | this.object_bytes[3] & 0xFF;
        this.Res = (this.object_bytes[1] & 0xC) >> 2;
        this.Pbit = (this.object_bytes[1] & 2) == 2;
        this.Ibit = (this.object_bytes[1] & 1) == 1;
    }

    public int getObjectClass() {
        return this.ObjectClass;
    }

    public void setObjectClass(int objectClass) {
        this.ObjectClass = objectClass;
    }

    public int getOT() {
        return this.OT;
    }

    public void setOT(int oT) {
        this.OT = oT;
    }

    public int getRes() {
        return this.Res;
    }

    public void setRes(int res) {
        this.Res = res;
    }

    public boolean isPbit() {
        return this.Pbit;
    }

    public void setPbit(boolean pbit) {
        this.Pbit = pbit;
    }

    public boolean isIbit() {
        return this.Ibit;
    }

    public void setIbit(boolean ibit) {
        this.Ibit = ibit;
    }

    @Override
    public int getLength() {
        return this.ObjectLength;
    }

    protected void setObjectLength(int objectLength) {
        this.ObjectLength = objectLength;
    }

    public byte[] getObject_bytes() {
        return this.object_bytes;
    }

    public void setObject_bytes(byte[] object_bytes) {
        this.object_bytes = object_bytes;
    }

    @Override
    public byte[] getBytes() {
        return this.object_bytes;
    }

    public static int getObjectClass(byte[] bytes, int offset) {
        try {
            int obc = bytes[offset] & 0xFF;
            return obc;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    public static int getObjectType(byte[] bytes, int offset) {
        try {
            int obc = (bytes[offset + 1] & 0xFF) >>> 4 & 0xF;
            return obc;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    public static int getObjectLength(byte[] bytes, int offset) {
        return (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
    }

    public static boolean supportedObject(int oc) {
        return !(oc > 15 | oc == 0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.Ibit ? 1231 : 1237);
        result = 31 * result + this.OT;
        result = 31 * result + this.ObjectClass;
        result = 31 * result + this.ObjectLength;
        result = 31 * result + (this.Pbit ? 1231 : 1237);
        result = 31 * result + this.Res;
        result = 31 * result + Arrays.hashCode(this.object_bytes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPObject other = (PCEPObject)obj;
        if (this.Ibit != other.Ibit) {
            return false;
        }
        if (this.OT != other.OT) {
            return false;
        }
        if (this.ObjectClass != other.ObjectClass) {
            return false;
        }
        if (this.ObjectLength != other.ObjectLength) {
            return false;
        }
        if (this.Pbit != other.Pbit) {
            return false;
        }
        if (this.Res != other.Res) {
            return false;
        }
        return Arrays.equals(this.object_bytes, other.object_bytes);
    }
}

