/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;

public class P2PGeneralizedEndPoints
extends GeneralizedEndPoints {
    private EndPointAndRestrictions sourceEndpoint;
    private EndPointAndRestrictions destinationEndpoint;

    public P2PGeneralizedEndPoints() {
        this.setGeneralizedEndPointsType(1);
    }

    public P2PGeneralizedEndPoints(byte[] bytes, int offset) throws MalformedPCEPObjectException, PCEPProtocolViolationException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        try {
            int len = 8;
            this.sourceEndpoint.encode();
            len += this.sourceEndpoint.getLength();
            this.destinationEndpoint.encode();
            this.setObjectLength(len += this.destinationEndpoint.getLength());
            this.object_bytes = new byte[this.getLength()];
            this.encode_header();
            this.encodeEndpointHeader();
            int offset = 8;
            System.arraycopy(this.sourceEndpoint.getBytes(), 0, this.object_bytes, offset, this.sourceEndpoint.getLength());
            System.arraycopy(this.destinationEndpoint.getBytes(), 0, this.object_bytes, offset += this.sourceEndpoint.getLength(), this.destinationEndpoint.getLength());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EndPointAndRestrictions getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    public void setSourceEndpoint(EndPointAndRestrictions sourceEndpoint) {
        this.sourceEndpoint = sourceEndpoint;
    }

    public EndPointAndRestrictions getDestinationEndpoint() {
        return this.destinationEndpoint;
    }

    public void setDestinationEndpoint(EndPointAndRestrictions destinationEndpoint) {
        this.destinationEndpoint = destinationEndpoint;
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        int offset = 8;
        this.sourceEndpoint = new EndPointAndRestrictions(this.getBytes(), offset);
        this.destinationEndpoint = new EndPointAndRestrictions(this.getBytes(), offset += this.sourceEndpoint.getLength());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<GEP_P2P src = ");
        sb.append(this.sourceEndpoint.toString());
        sb.append(" dst = ");
        sb.append(this.destinationEndpoint.toString());
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.destinationEndpoint == null ? 0 : this.destinationEndpoint.hashCode());
        result = 31 * result + (this.sourceEndpoint == null ? 0 : this.sourceEndpoint.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        P2PGeneralizedEndPoints other = (P2PGeneralizedEndPoints)obj;
        if (this.destinationEndpoint == null ? other.destinationEndpoint != null : !this.destinationEndpoint.equals(other.destinationEndpoint)) {
            return false;
        }
        return !(this.sourceEndpoint == null ? other.sourceEndpoint != null : !this.sourceEndpoint.equals(other.sourceEndpoint));
    }
}

