/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class P2MPEndPointsIPv4
extends EndPoints {
    private int leafType;
    private Inet4Address sourceIP;
    private LinkedList<Inet4Address> destIPList = new LinkedList();

    public P2MPEndPointsIPv4() {
        this.setObjectClass(4);
        this.setOT(3);
    }

    public P2MPEndPointsIPv4(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 12 + 4 * this.destIPList.size();
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        this.object_bytes[4] = (byte)(this.leafType >>> 24);
        this.object_bytes[5] = (byte)(this.leafType >>> 16 & 0xFF);
        this.object_bytes[6] = (byte)(this.leafType >>> 8 & 0xFF);
        this.object_bytes[7] = (byte)(this.leafType & 0xFF);
        System.arraycopy(this.sourceIP.getAddress(), 0, this.object_bytes, 8, 4);
        int i = 0;
        while (i < this.destIPList.size()) {
            System.arraycopy(this.destIPList.get(i).getAddress(), 0, this.object_bytes, 12 + 4 * i, 4);
            ++i;
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength < 16 || this.ObjectLength % 4 != 0) {
            throw new MalformedPCEPObjectException();
        }
        this.leafType = 0;
        int k = 0;
        while (k < 4) {
            this.leafType = this.leafType << 8 | this.object_bytes[k + 4] & 0xFF;
            ++k;
        }
        int numDestId = (this.ObjectLength - 4 - 4 - 4) / 4;
        byte[] ip = new byte[4];
        System.arraycopy(this.object_bytes, 8, ip, 0, 4);
        try {
            this.sourceIP = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < numDestId) {
            System.arraycopy(this.object_bytes, 12 + 4 * i, ip, 0, 4);
            try {
                this.destIPList.add((Inet4Address)Inet4Address.getByAddress(ip));
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public LinkedList<Inet4Address> getDestIPList() {
        return this.destIPList;
    }

    public void setDestIPList(LinkedList<Inet4Address> destIPList) {
        this.destIPList = destIPList;
    }

    public Inet4Address getSourceIP() {
        return this.sourceIP;
    }

    public void setSourceIP(Inet4Address sourceIP) {
        this.sourceIP = sourceIP;
    }

    public Inet4Address getDestIP(int index) {
        return this.destIPList.get(index);
    }

    public void setDestIP(Inet4Address destIP) {
        this.destIPList.add(destIP);
    }

    public int getLeafType() {
        return this.leafType;
    }

    public void setLeafType(int leafType) {
        this.leafType = leafType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.destIPList.size() * 100);
        sb.append("<Leaf type: " + this.leafType);
        sb.append(" Source IP: " + String.valueOf(this.sourceIP));
        int i = 0;
        while (i < this.destIPList.size()) {
            sb.append(" Destination IP" + i + ": " + this.destIPList.get(i).toString());
            ++i;
        }
        sb.append(">");
        return sb.toString();
    }
}

