/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.tlvs.ASSOCTypeListTLV;
import es.tid.pce.pcep.objects.tlvs.DomainIDTLV;
import es.tid.pce.pcep.objects.tlvs.EmptyDomainIDTLV;
import es.tid.pce.pcep.objects.tlvs.GMPLSCapabilityTLV;
import es.tid.pce.pcep.objects.tlvs.LSPDatabaseVersionTLV;
import es.tid.pce.pcep.objects.tlvs.OF_LIST_TLV;
import es.tid.pce.pcep.objects.tlvs.OSPFDomainIDTLV;
import es.tid.pce.pcep.objects.tlvs.OpConfAssocRangeTLV;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.pce.pcep.objects.tlvs.PCE_ID_TLV;
import es.tid.pce.pcep.objects.tlvs.PCE_Redundancy_Group_Identifier_TLV;
import es.tid.pce.pcep.objects.tlvs.PathSetupCapabilityTLV;
import es.tid.pce.pcep.objects.tlvs.SRCapabilityTLV;
import es.tid.pce.pcep.objects.tlvs.StatefulCapabilityTLV;

public class OPEN
extends PCEPObject {
    private int Ver;
    private boolean parentPCERequestBit;
    private boolean parentPCEIndicationBit;
    private int Keepalive;
    private int Deadtimer;
    private int SID;
    private OF_LIST_TLV of_list_tlv;
    private DomainIDTLV domain_id_tlv;
    private PCE_ID_TLV pce_id_tlv;
    private GMPLSCapabilityTLV gmplsCapabilityTLV;
    private StatefulCapabilityTLV stateful_capability_tlv = null;
    private SRCapabilityTLV SR_capability_tlv = null;
    private LSPDatabaseVersionTLV lsp_database_version_tlv = null;
    private PCE_Redundancy_Group_Identifier_TLV redundancy_indetifier_tlv = null;
    private ASSOCTypeListTLV assoc_type_list_tlv = null;
    private OpConfAssocRangeTLV op_conf_assoc_range_tlv = null;
    private PathSetupCapabilityTLV pathSetupCababiity = null;

    public OPEN() {
        this.setObjectClass(1);
        this.setOT(1);
        this.Ver = 1;
        this.Keepalive = 30;
        this.Deadtimer = 120;
        this.SID = 1;
        this.parentPCERequestBit = false;
        this.parentPCEIndicationBit = false;
    }

    public OPEN(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 8;
        if (this.of_list_tlv != null) {
            this.of_list_tlv.encode();
            this.ObjectLength += this.of_list_tlv.getTotalTLVLength();
        }
        if (this.domain_id_tlv != null) {
            this.domain_id_tlv.encode();
            this.ObjectLength += this.domain_id_tlv.getTotalTLVLength();
        }
        if (this.pce_id_tlv != null) {
            this.pce_id_tlv.encode();
            this.ObjectLength += this.pce_id_tlv.getTotalTLVLength();
        }
        if (this.gmplsCapabilityTLV != null) {
            this.gmplsCapabilityTLV.encode();
            this.ObjectLength += this.gmplsCapabilityTLV.getTotalTLVLength();
        }
        if (this.stateful_capability_tlv != null) {
            this.stateful_capability_tlv.encode();
            this.ObjectLength += this.stateful_capability_tlv.getTotalTLVLength();
        }
        if (this.SR_capability_tlv != null) {
            this.SR_capability_tlv.encode();
            this.ObjectLength += this.SR_capability_tlv.getTotalTLVLength();
        }
        if (this.lsp_database_version_tlv != null) {
            this.lsp_database_version_tlv.encode();
            this.ObjectLength += this.lsp_database_version_tlv.getTotalTLVLength();
        }
        if (this.redundancy_indetifier_tlv != null) {
            this.redundancy_indetifier_tlv.encode();
            this.ObjectLength += this.redundancy_indetifier_tlv.getTotalTLVLength();
        }
        if (this.assoc_type_list_tlv != null) {
            this.assoc_type_list_tlv.encode();
            this.ObjectLength += this.assoc_type_list_tlv.getTotalTLVLength();
        }
        if (this.op_conf_assoc_range_tlv != null) {
            this.op_conf_assoc_range_tlv.encode();
            this.ObjectLength += this.op_conf_assoc_range_tlv.getTotalTLVLength();
        }
        if (this.pathSetupCababiity != null) {
            this.pathSetupCababiity.encode();
            this.ObjectLength += this.pathSetupCababiity.getTotalTLVLength();
        }
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        this.object_bytes[4] = (byte)(this.Ver << 5 & 0xE0 | (this.parentPCEIndicationBit ? 1 : 0) << 3 & 8 | (this.parentPCERequestBit ? 1 : 0) << 4 & 0x10);
        this.object_bytes[5] = (byte)this.Keepalive;
        this.object_bytes[6] = (byte)this.Deadtimer;
        this.object_bytes[7] = (byte)(this.SID & 0xFF);
        int offset = 8;
        if (this.of_list_tlv != null) {
            System.arraycopy(this.of_list_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.of_list_tlv.getTotalTLVLength());
            offset += this.of_list_tlv.getTotalTLVLength();
        }
        if (this.domain_id_tlv != null) {
            System.arraycopy(this.domain_id_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.domain_id_tlv.getTotalTLVLength());
            offset += this.domain_id_tlv.getTotalTLVLength();
        }
        if (this.pce_id_tlv != null) {
            System.arraycopy(this.pce_id_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.pce_id_tlv.getTotalTLVLength());
            offset += this.pce_id_tlv.getTotalTLVLength();
        }
        if (this.gmplsCapabilityTLV != null) {
            System.arraycopy(this.gmplsCapabilityTLV.getTlv_bytes(), 0, this.object_bytes, offset, this.gmplsCapabilityTLV.getTotalTLVLength());
            offset += this.gmplsCapabilityTLV.getTotalTLVLength();
        }
        if (this.stateful_capability_tlv != null) {
            System.arraycopy(this.stateful_capability_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.stateful_capability_tlv.getTotalTLVLength());
            offset += this.stateful_capability_tlv.getTotalTLVLength();
        }
        if (this.SR_capability_tlv != null) {
            System.arraycopy(this.SR_capability_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.SR_capability_tlv.getTotalTLVLength());
            offset += this.SR_capability_tlv.getTotalTLVLength();
        }
        if (this.lsp_database_version_tlv != null) {
            System.arraycopy(this.lsp_database_version_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.lsp_database_version_tlv.getTotalTLVLength());
            offset += this.lsp_database_version_tlv.getTotalTLVLength();
        }
        if (this.redundancy_indetifier_tlv != null) {
            System.arraycopy(this.redundancy_indetifier_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.redundancy_indetifier_tlv.getTotalTLVLength());
            offset += this.redundancy_indetifier_tlv.getTotalTLVLength();
        }
        if (this.assoc_type_list_tlv != null) {
            System.arraycopy(this.assoc_type_list_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.assoc_type_list_tlv.getTotalTLVLength());
            offset += this.assoc_type_list_tlv.getTotalTLVLength();
        }
        if (this.op_conf_assoc_range_tlv != null) {
            System.arraycopy(this.op_conf_assoc_range_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.op_conf_assoc_range_tlv.getTotalTLVLength());
            offset += this.op_conf_assoc_range_tlv.getTotalTLVLength();
        }
        if (this.pathSetupCababiity != null) {
            System.arraycopy(this.pathSetupCababiity.getTlv_bytes(), 0, this.object_bytes, offset, this.pathSetupCababiity.getTotalTLVLength());
            offset += this.pathSetupCababiity.getTotalTLVLength();
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        this.redundancy_indetifier_tlv = null;
        this.lsp_database_version_tlv = null;
        this.stateful_capability_tlv = null;
        this.SR_capability_tlv = null;
        this.assoc_type_list_tlv = null;
        this.Ver = this.object_bytes[4] >>> 5 & 7;
        this.parentPCEIndicationBit = (this.object_bytes[4] & 8) == 8;
        this.parentPCERequestBit = (this.object_bytes[4] & 0x10) == 16;
        this.Keepalive = this.object_bytes[5] & 0xFF;
        this.Deadtimer = this.object_bytes[6] & 0xFF;
        this.SID = this.object_bytes[7] & 0xFF;
        boolean fin = false;
        int offset = 8;
        if (this.ObjectLength == 8) {
            fin = true;
        }
        while (!fin) {
            int tlvtype = PCEPTLV.getType(this.getObject_bytes(), offset);
            int tlvlength = PCEPTLV.getTotalTLVLength(this.getObject_bytes(), offset);
            switch (tlvtype) {
                case 4: {
                    this.of_list_tlv = new OF_LIST_TLV(this.getObject_bytes(), offset);
                    break;
                }
                case 14: {
                    int domainType = DomainIDTLV.getDomainType(this.getObject_bytes(), offset);
                    if (domainType == 0) {
                        this.domain_id_tlv = new EmptyDomainIDTLV(this.getObject_bytes(), offset);
                        break;
                    }
                    if (domainType != 3) break;
                    this.domain_id_tlv = new OSPFDomainIDTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 32769: {
                    this.pce_id_tlv = new PCE_ID_TLV(this.getObject_bytes(), offset);
                    break;
                }
                case 45: {
                    this.gmplsCapabilityTLV = new GMPLSCapabilityTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 16: {
                    this.stateful_capability_tlv = new StatefulCapabilityTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 26: {
                    this.SR_capability_tlv = new SRCapabilityTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 23: {
                    this.lsp_database_version_tlv = new LSPDatabaseVersionTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 5557: {
                    this.redundancy_indetifier_tlv = new PCE_Redundancy_Group_Identifier_TLV(this.getObject_bytes(), offset);
                    break;
                }
                case 35: {
                    this.assoc_type_list_tlv = new ASSOCTypeListTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 29: {
                    this.op_conf_assoc_range_tlv = new OpConfAssocRangeTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 34: {
                    this.pathSetupCababiity = new PathSetupCapabilityTLV(this.getObject_bytes(), offset);
                    break;
                }
                default: {
                    log.debug("UNKNOWN TLV found");
                }
            }
            if ((offset += tlvlength) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public int getDeadtimer() {
        return this.Deadtimer;
    }

    public int getKeepalive() {
        return this.Keepalive;
    }

    public int getSID() {
        return this.SID;
    }

    public int getVer() {
        return this.Ver;
    }

    public void setDeadtimer(int dt) {
        this.Deadtimer = (byte)dt;
    }

    public void setKeepalive(int keepalive) {
        this.Keepalive = keepalive;
    }

    public void setSID(int sd) {
        this.SID = sd;
    }

    public void setVer(int version) {
        if (version <= 7 && version >= 0) {
            this.Ver = (byte)version;
        }
    }

    public boolean isParentPCERequestBit() {
        return this.parentPCERequestBit;
    }

    public void setParentPCERequestBit(boolean parentPCERequestBit) {
        this.parentPCERequestBit = parentPCERequestBit;
    }

    public boolean isParentPCEIndicationBit() {
        return this.parentPCEIndicationBit;
    }

    public void setParentPCEIndicationBit(boolean parentPCEIndicationBit) {
        this.parentPCEIndicationBit = parentPCEIndicationBit;
    }

    public OF_LIST_TLV getOf_list_tlv() {
        return this.of_list_tlv;
    }

    public void setOf_list_tlv(OF_LIST_TLV of_list_tlv) {
        this.of_list_tlv = of_list_tlv;
    }

    public DomainIDTLV getDomain_id_tlv() {
        return this.domain_id_tlv;
    }

    public void setDomain_id_tlv(DomainIDTLV domain_id_tlv) {
        this.domain_id_tlv = domain_id_tlv;
    }

    public PCE_ID_TLV getPce_id_tlv() {
        return this.pce_id_tlv;
    }

    public void setPce_id_tlv(PCE_ID_TLV pce_id_tlv) {
        this.pce_id_tlv = pce_id_tlv;
    }

    public StatefulCapabilityTLV getStateful_capability_tlv() {
        return this.stateful_capability_tlv;
    }

    public void setStateful_capability_tlv(StatefulCapabilityTLV stateful_capability_tlv) {
        this.stateful_capability_tlv = stateful_capability_tlv;
    }

    public SRCapabilityTLV getSR_capability_tlv() {
        return this.SR_capability_tlv;
    }

    public void setSR_capability_tlv(SRCapabilityTLV SR_capability_tlv) {
        this.SR_capability_tlv = SR_capability_tlv;
    }

    public LSPDatabaseVersionTLV getLsp_database_version_tlv() {
        return this.lsp_database_version_tlv;
    }

    public void setLsp_database_version_tlv(LSPDatabaseVersionTLV lsp_database_version_tlv) {
        this.lsp_database_version_tlv = lsp_database_version_tlv;
    }

    public PCE_Redundancy_Group_Identifier_TLV getRedundancy_indetifier_tlv() {
        return this.redundancy_indetifier_tlv;
    }

    public void setRedundancy_indetifier_tlv(PCE_Redundancy_Group_Identifier_TLV redundancy_indetifier_tlv) {
        this.redundancy_indetifier_tlv = redundancy_indetifier_tlv;
    }

    public GMPLSCapabilityTLV getGmplsCapabilityTLV() {
        return this.gmplsCapabilityTLV;
    }

    public void setGmplsCapabilityTLV(GMPLSCapabilityTLV gmplsCapabilityTLV) {
        this.gmplsCapabilityTLV = gmplsCapabilityTLV;
    }

    public ASSOCTypeListTLV getAssoc_type_list_tlv() {
        return this.assoc_type_list_tlv;
    }

    public void setAssoc_type_list_tlv(ASSOCTypeListTLV assoc_type_list_tlv) {
        this.assoc_type_list_tlv = assoc_type_list_tlv;
    }

    public OpConfAssocRangeTLV getOp_conf_assoc_range_tlv() {
        return this.op_conf_assoc_range_tlv;
    }

    public void setOp_conf_assoc_range_tlv(OpConfAssocRangeTLV op_conf_assoc_range_tlv) {
        this.op_conf_assoc_range_tlv = op_conf_assoc_range_tlv;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.Deadtimer;
        result = 31 * result + this.Keepalive;
        result = 31 * result + this.SID;
        result = 31 * result + (this.SR_capability_tlv == null ? 0 : this.SR_capability_tlv.hashCode());
        result = 31 * result + this.Ver;
        result = 31 * result + (this.assoc_type_list_tlv == null ? 0 : this.assoc_type_list_tlv.hashCode());
        result = 31 * result + (this.domain_id_tlv == null ? 0 : this.domain_id_tlv.hashCode());
        result = 31 * result + (this.gmplsCapabilityTLV == null ? 0 : this.gmplsCapabilityTLV.hashCode());
        result = 31 * result + (this.lsp_database_version_tlv == null ? 0 : this.lsp_database_version_tlv.hashCode());
        result = 31 * result + (this.of_list_tlv == null ? 0 : this.of_list_tlv.hashCode());
        result = 31 * result + (this.op_conf_assoc_range_tlv == null ? 0 : this.op_conf_assoc_range_tlv.hashCode());
        result = 31 * result + (this.parentPCEIndicationBit ? 1231 : 1237);
        result = 31 * result + (this.parentPCERequestBit ? 1231 : 1237);
        result = 31 * result + (this.pathSetupCababiity == null ? 0 : this.pathSetupCababiity.hashCode());
        result = 31 * result + (this.pce_id_tlv == null ? 0 : this.pce_id_tlv.hashCode());
        result = 31 * result + (this.redundancy_indetifier_tlv == null ? 0 : this.redundancy_indetifier_tlv.hashCode());
        result = 31 * result + (this.stateful_capability_tlv == null ? 0 : this.stateful_capability_tlv.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPEN other = (OPEN)obj;
        if (this.Deadtimer != other.Deadtimer) {
            return false;
        }
        if (this.Keepalive != other.Keepalive) {
            return false;
        }
        if (this.SID != other.SID) {
            return false;
        }
        if (this.SR_capability_tlv == null ? other.SR_capability_tlv != null : !this.SR_capability_tlv.equals(other.SR_capability_tlv)) {
            return false;
        }
        if (this.Ver != other.Ver) {
            return false;
        }
        if (this.assoc_type_list_tlv == null ? other.assoc_type_list_tlv != null : !this.assoc_type_list_tlv.equals(other.assoc_type_list_tlv)) {
            return false;
        }
        if (this.domain_id_tlv == null ? other.domain_id_tlv != null : !this.domain_id_tlv.equals(other.domain_id_tlv)) {
            return false;
        }
        if (this.gmplsCapabilityTLV == null ? other.gmplsCapabilityTLV != null : !this.gmplsCapabilityTLV.equals(other.gmplsCapabilityTLV)) {
            return false;
        }
        if (this.lsp_database_version_tlv == null ? other.lsp_database_version_tlv != null : !this.lsp_database_version_tlv.equals(other.lsp_database_version_tlv)) {
            return false;
        }
        if (this.of_list_tlv == null ? other.of_list_tlv != null : !this.of_list_tlv.equals(other.of_list_tlv)) {
            return false;
        }
        if (this.op_conf_assoc_range_tlv == null ? other.op_conf_assoc_range_tlv != null : !this.op_conf_assoc_range_tlv.equals(other.op_conf_assoc_range_tlv)) {
            return false;
        }
        if (this.parentPCEIndicationBit != other.parentPCEIndicationBit) {
            return false;
        }
        if (this.parentPCERequestBit != other.parentPCERequestBit) {
            return false;
        }
        if (this.pathSetupCababiity == null ? other.pathSetupCababiity != null : !this.pathSetupCababiity.equals(other.pathSetupCababiity)) {
            return false;
        }
        if (this.pce_id_tlv == null ? other.pce_id_tlv != null : !this.pce_id_tlv.equals(other.pce_id_tlv)) {
            return false;
        }
        if (this.redundancy_indetifier_tlv == null ? other.redundancy_indetifier_tlv != null : !this.redundancy_indetifier_tlv.equals(other.redundancy_indetifier_tlv)) {
            return false;
        }
        return !(this.stateful_capability_tlv == null ? other.stateful_capability_tlv != null : !this.stateful_capability_tlv.equals(other.stateful_capability_tlv));
    }

    public String toString() {
        return "OPEN [Ver=" + this.Ver + ", parentPCERequestBit=" + this.parentPCERequestBit + ", parentPCEIndicationBit=" + this.parentPCEIndicationBit + ", Keepalive=" + this.Keepalive + ", Deadtimer=" + this.Deadtimer + ", SID=" + this.SID + ", of_list_tlv=" + String.valueOf(this.of_list_tlv) + ", domain_id_tlv=" + String.valueOf(this.domain_id_tlv) + ", pce_id_tlv=" + String.valueOf(this.pce_id_tlv) + ", gmplsCapabilityTLV=" + String.valueOf(this.gmplsCapabilityTLV) + ", stateful_capability_tlv=" + String.valueOf(this.stateful_capability_tlv) + ", SR_capability_tlv=" + String.valueOf(this.SR_capability_tlv) + ", lsp_database_version_tlv=" + String.valueOf(this.lsp_database_version_tlv) + ", redundancy_indetifier_tlv=" + String.valueOf(this.redundancy_indetifier_tlv) + ", assoc_type_list_tlv=" + String.valueOf(this.assoc_type_list_tlv) + ", op_conf_assoc_range_tlv=" + String.valueOf(this.op_conf_assoc_range_tlv) + ", pathSetupCababiity=" + String.valueOf(this.pathSetupCababiity) + "]";
    }

    public PathSetupCapabilityTLV getPathSetupCababiity() {
        return this.pathSetupCababiity;
    }

    public void setPathSetupCababiity(PathSetupCapabilityTLV pathSetupCababiity) {
        this.pathSetupCababiity = pathSetupCababiity;
    }
}

