/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.pce.pcep.objects.tlvs.RequestInfoTLV;

public class Monitoring
extends PCEPObject {
    private boolean livenessBit;
    private boolean generalBit;
    private boolean processingTimeBit;
    private boolean overloadBit;
    private boolean incompleteBit;
    private long monitoringIdNumber;
    private RequestInfoTLV requestInfoTLV;

    public Monitoring() {
        this.setObjectClass(19);
        this.setOT(1);
    }

    public Monitoring(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 12;
        if (this.requestInfoTLV != null) {
            this.requestInfoTLV.encode();
            this.ObjectLength += this.requestInfoTLV.getTotalTLVLength();
        }
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        int offset = 7;
        this.object_bytes[offset] = (byte)((this.livenessBit ? 1 : 0) & 1 | (this.generalBit ? 1 : 0) << 1 & 2 | (this.processingTimeBit ? 1 : 0) << 2 & 4 | (this.overloadBit ? 1 : 0) << 3 & 8 | (this.incompleteBit ? 1 : 0) << 4 & 0x10);
        this.object_bytes[offset + 1] = (byte)(this.monitoringIdNumber >> 24 & 0xFFL);
        this.object_bytes[offset + 2] = (byte)(this.monitoringIdNumber >> 16 & 0xFFL);
        this.object_bytes[offset + 3] = (byte)(this.monitoringIdNumber >> 8 & 0xFFL);
        this.object_bytes[offset + 4] = (byte)(this.monitoringIdNumber & 0xFFL);
        offset += 5;
        if (this.requestInfoTLV != null) {
            System.arraycopy(this.requestInfoTLV.getTlv_bytes(), 0, this.object_bytes, offset, this.requestInfoTLV.getTotalTLVLength());
            offset += this.requestInfoTLV.getTotalTLVLength();
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        this.livenessBit = (this.object_bytes[7] & 1) == 1;
        this.generalBit = (this.object_bytes[7] & 2) == 2;
        this.processingTimeBit = (this.object_bytes[7] & 4) == 4;
        this.overloadBit = (this.object_bytes[7] & 8) == 8;
        this.incompleteBit = (this.object_bytes[7] & 0x10) == 16;
        this.monitoringIdNumber = (long)(this.object_bytes[8] << 24 | this.object_bytes[9] << 16 | this.object_bytes[10] << 8 | this.object_bytes[11]) & 0xFFFFFFFFL;
        boolean fin = false;
        int offset = 12;
        if (this.ObjectLength == 12) {
            fin = true;
        }
        while (!fin) {
            int tlvtype = PCEPTLV.getType(this.getObject_bytes(), offset);
            int tlvlength = PCEPTLV.getTotalTLVLength(this.getObject_bytes(), offset);
            switch (tlvtype) {
                case 3070: {
                    this.requestInfoTLV = new RequestInfoTLV(this.getObject_bytes(), offset);
                    break;
                }
                default: {
                    log.warn("UNKNOWN TLV found: " + tlvtype);
                }
            }
            if ((offset += tlvlength) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public boolean isLivenessBit() {
        return this.livenessBit;
    }

    public void setLivenessBit(boolean livenessBit) {
        this.livenessBit = livenessBit;
    }

    public boolean isGeneralBit() {
        return this.generalBit;
    }

    public void setGeneralBit(boolean generalBit) {
        this.generalBit = generalBit;
    }

    public boolean isProcessingTimeBit() {
        return this.processingTimeBit;
    }

    public void setProcessingTimeBit(boolean processingTimeBit) {
        this.processingTimeBit = processingTimeBit;
    }

    public boolean isOverloadBit() {
        return this.overloadBit;
    }

    public void setOverloadBit(boolean overloadBit) {
        this.overloadBit = overloadBit;
    }

    public boolean isIncompleteBit() {
        return this.incompleteBit;
    }

    public void setIncompleteBit(boolean incompleteBit) {
        this.incompleteBit = incompleteBit;
    }

    public long getMonitoringIdNumber() {
        return this.monitoringIdNumber;
    }

    public void setMonitoringIdNumber(long monitoringIdNumber) {
        this.monitoringIdNumber = monitoringIdNumber;
    }

    public RequestInfoTLV getRequestInfoTLV() {
        return this.requestInfoTLV;
    }

    public void setRequestInfoTLV(RequestInfoTLV requestInfoTLV) {
        this.requestInfoTLV = requestInfoTLV;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Monitoring: ");
        sb.append(this.object_bytes[8]);
        sb.append(this.object_bytes[9]);
        sb.append(this.object_bytes[10]);
        sb.append(this.object_bytes[11]);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.generalBit ? 1231 : 1237);
        result = 31 * result + (this.incompleteBit ? 1231 : 1237);
        result = 31 * result + (this.livenessBit ? 1231 : 1237);
        result = 31 * result + (int)(this.monitoringIdNumber ^ this.monitoringIdNumber >>> 32);
        result = 31 * result + (this.overloadBit ? 1231 : 1237);
        result = 31 * result + (this.processingTimeBit ? 1231 : 1237);
        result = 31 * result + (this.requestInfoTLV == null ? 0 : this.requestInfoTLV.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Monitoring other = (Monitoring)obj;
        if (this.generalBit != other.generalBit) {
            return false;
        }
        if (this.incompleteBit != other.incompleteBit) {
            return false;
        }
        if (this.livenessBit != other.livenessBit) {
            return false;
        }
        if (this.monitoringIdNumber != other.monitoringIdNumber) {
            return false;
        }
        if (this.overloadBit != other.overloadBit) {
            return false;
        }
        if (this.processingTimeBit != other.processingTimeBit) {
            return false;
        }
        return !(this.requestInfoTLV == null ? other.requestInfoTLV != null : !this.requestInfoTLV.equals(other.requestInfoTLV));
    }
}

