/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;

public class LoadBalancing
extends PCEPObject {
    private int MaxLSP;
    private float MinBandwidth;

    public LoadBalancing() {
        this.setObjectClass(14);
        this.setOT(1);
    }

    public LoadBalancing(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 12;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        int bwi = Float.floatToIntBits(this.MinBandwidth);
        this.object_bytes[4] = 0;
        this.object_bytes[5] = 0;
        this.object_bytes[6] = 0;
        this.object_bytes[7] = (byte)(this.MaxLSP & 0xFF);
        this.object_bytes[8] = (byte)(bwi >>> 24);
        this.object_bytes[9] = (byte)(bwi >> 16 & 0xFF);
        this.object_bytes[10] = (byte)(bwi >> 8 & 0xFF);
        this.object_bytes[11] = (byte)(bwi & 0xFF);
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength != 12) {
            throw new MalformedPCEPObjectException();
        }
        this.MaxLSP = this.object_bytes[7];
        int bwi = 0;
        int k = 0;
        while (k < 4) {
            bwi = bwi << 8 | this.object_bytes[k + 8] & 0xFF;
            ++k;
        }
        this.MinBandwidth = Float.intBitsToFloat(bwi);
    }

    public int getMaxLSP() {
        return this.MaxLSP;
    }

    public void setMaxLSP(int maxLSP) {
        this.MaxLSP = maxLSP;
    }

    public float getMinBandwidth() {
        return this.MinBandwidth;
    }

    public void setMinBandwidth(float minBandwidth) {
        this.MinBandwidth = minBandwidth;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.MaxLSP;
        result = 31 * result + Float.floatToIntBits(this.MinBandwidth);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancing other = (LoadBalancing)obj;
        if (this.MaxLSP != other.MaxLSP) {
            return false;
        }
        return Float.floatToIntBits(this.MinBandwidth) == Float.floatToIntBits(other.MinBandwidth);
    }
}

