/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.tlvs.IPv4LSPIdentifiersTLV;
import es.tid.pce.pcep.objects.tlvs.LSPDatabaseVersionTLV;
import es.tid.pce.pcep.objects.tlvs.LSPErrorCodeTLV;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.pce.pcep.objects.tlvs.RSVPErrorSpecTLV;
import es.tid.pce.pcep.objects.tlvs.SymbolicPathNameTLV;
import es.tid.protocol.commons.ByteHandler;

public class LSP
extends PCEPObject {
    protected int lspId;
    protected boolean delegateFlag = false;
    protected boolean syncFlag = false;
    protected boolean removeFlag = false;
    protected boolean administrativeFlag = false;
    protected int opFlags;
    protected boolean createFlag = false;
    protected boolean p2mpFlag = false;
    protected boolean fragmentationFlag = false;
    protected boolean eroCompressionFlag = false;
    private SymbolicPathNameTLV symbolicPathNameTLV_tlv = null;
    private IPv4LSPIdentifiersTLV lspIdentifiers_tlv = null;
    private LSPErrorCodeTLV lspErrorCodes_tlv = null;
    private RSVPErrorSpecTLV rsvpErrorSpec_tlv = null;
    private LSPDatabaseVersionTLV lspDBVersion_tlv = null;

    public LSP() {
        this.ObjectClass = 32;
        this.setOT(1);
    }

    public LSP(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 8;
        if (this.symbolicPathNameTLV_tlv != null) {
            this.symbolicPathNameTLV_tlv.encode();
            this.ObjectLength += this.symbolicPathNameTLV_tlv.getTotalTLVLength();
        }
        if (this.lspIdentifiers_tlv != null) {
            this.lspIdentifiers_tlv.encode();
            this.ObjectLength += this.lspIdentifiers_tlv.getTotalTLVLength();
        }
        if (this.lspErrorCodes_tlv != null) {
            this.lspErrorCodes_tlv.encode();
            this.ObjectLength += this.lspErrorCodes_tlv.getTotalTLVLength();
        }
        if (this.rsvpErrorSpec_tlv != null) {
            this.rsvpErrorSpec_tlv.encode();
            this.ObjectLength += this.rsvpErrorSpec_tlv.getTotalTLVLength();
        }
        if (this.lspDBVersion_tlv != null) {
            this.lspDBVersion_tlv.encode();
            this.ObjectLength += this.lspDBVersion_tlv.getTotalTLVLength();
        }
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        int offset = 4;
        ByteHandler.IntToBuffer(12, offset * 8, 20, this.lspId, this.object_bytes);
        ByteHandler.BoolToBuffer(5 + (offset += 2) * 8, this.eroCompressionFlag, this.object_bytes);
        ByteHandler.BoolToBuffer(6 + offset * 8, this.fragmentationFlag, this.object_bytes);
        ByteHandler.BoolToBuffer(7 + offset * 8, this.p2mpFlag, this.object_bytes);
        ByteHandler.BoolToBuffer(0 + ++offset * 8, this.createFlag, this.object_bytes);
        ByteHandler.IntToBuffer(29, 1 + offset * 8, 3, this.opFlags, this.object_bytes);
        ByteHandler.BoolToBuffer(4 + offset * 8, this.administrativeFlag, this.object_bytes);
        ByteHandler.BoolToBuffer(5 + offset * 8, this.removeFlag, this.object_bytes);
        ByteHandler.BoolToBuffer(6 + offset * 8, this.syncFlag, this.object_bytes);
        ByteHandler.BoolToBuffer(7 + offset * 8, this.delegateFlag, this.object_bytes);
        ++offset;
        if (this.symbolicPathNameTLV_tlv != null) {
            System.arraycopy(this.symbolicPathNameTLV_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.symbolicPathNameTLV_tlv.getTotalTLVLength());
            offset += this.symbolicPathNameTLV_tlv.getTotalTLVLength();
        }
        if (this.lspIdentifiers_tlv != null) {
            System.arraycopy(this.lspIdentifiers_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.lspIdentifiers_tlv.getTotalTLVLength());
            offset += this.lspIdentifiers_tlv.getTotalTLVLength();
        }
        if (this.lspErrorCodes_tlv != null) {
            System.arraycopy(this.lspErrorCodes_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.lspErrorCodes_tlv.getTotalTLVLength());
            offset += this.lspErrorCodes_tlv.getTotalTLVLength();
        }
        if (this.rsvpErrorSpec_tlv != null) {
            System.arraycopy(this.rsvpErrorSpec_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.rsvpErrorSpec_tlv.getTotalTLVLength());
            offset += this.rsvpErrorSpec_tlv.getTotalTLVLength();
        }
        if (this.lspDBVersion_tlv != null) {
            System.arraycopy(this.lspDBVersion_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.lspDBVersion_tlv.getTotalTLVLength());
            offset += this.lspDBVersion_tlv.getTotalTLVLength();
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        log.debug("Decoding LSP object with length " + this.ObjectLength);
        this.symbolicPathNameTLV_tlv = null;
        this.lspIdentifiers_tlv = null;
        this.lspErrorCodes_tlv = null;
        this.rsvpErrorSpec_tlv = null;
        this.lspDBVersion_tlv = null;
        if (this.ObjectLength < 8) {
            throw new MalformedPCEPObjectException();
        }
        this.lspId = ByteHandler.easyCopy(0, 19, this.object_bytes[4], this.object_bytes[5], this.object_bytes[6]);
        this.p2mpFlag = (this.object_bytes[6] & 1) == 1;
        this.fragmentationFlag = (this.object_bytes[6] & 2) == 2;
        this.eroCompressionFlag = (this.object_bytes[6] & 4) == 4;
        this.createFlag = ByteHandler.easyCopy(0, 0, this.object_bytes[7]) == 1;
        this.opFlags = ByteHandler.easyCopy(1, 3, this.object_bytes[7]);
        this.administrativeFlag = ByteHandler.easyCopy(4, 4, this.object_bytes[7]) == 1;
        this.removeFlag = ByteHandler.easyCopy(5, 5, this.object_bytes[7]) == 1;
        this.syncFlag = ByteHandler.easyCopy(6, 6, this.object_bytes[7]) == 1;
        this.delegateFlag = ByteHandler.easyCopy(7, 7, this.object_bytes[7]) == 1;
        int offset = 8;
        boolean fin = this.ObjectLength == 8;
        while (!fin) {
            int tlvtype = PCEPTLV.getType(this.getObject_bytes(), offset);
            int tlvlength = PCEPTLV.getTotalTLVLength(this.getObject_bytes(), offset);
            switch (tlvtype) {
                case 17: {
                    this.symbolicPathNameTLV_tlv = new SymbolicPathNameTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 18: {
                    this.lspIdentifiers_tlv = new IPv4LSPIdentifiersTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 20: {
                    this.lspErrorCodes_tlv = new LSPErrorCodeTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 21: {
                    this.rsvpErrorSpec_tlv = new RSVPErrorSpecTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 23: {
                    this.lspDBVersion_tlv = new LSPDatabaseVersionTLV(this.getObject_bytes(), offset);
                    break;
                }
                default: {
                    log.warn("Unknown or unexpected TLV found");
                }
            }
            if ((offset += tlvlength) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public int getLspId() {
        return this.lspId;
    }

    public SymbolicPathNameTLV getSymbolicPathNameTLV_tlv() {
        return this.symbolicPathNameTLV_tlv;
    }

    public void setSymbolicPathNameTLV_tlv(SymbolicPathNameTLV symbolicPathNameTLV_tlv) {
        this.symbolicPathNameTLV_tlv = symbolicPathNameTLV_tlv;
    }

    public IPv4LSPIdentifiersTLV getLspIdentifiers_tlv() {
        return this.lspIdentifiers_tlv;
    }

    public void setLspIdentifiers_tlv(IPv4LSPIdentifiersTLV lspIdentifiers_tlv) {
        this.lspIdentifiers_tlv = lspIdentifiers_tlv;
    }

    public LSPErrorCodeTLV getLspErrorCodes_tlv() {
        return this.lspErrorCodes_tlv;
    }

    public void setLspErrorCodes_tlv(LSPErrorCodeTLV lspErrorCodes_tlv) {
        this.lspErrorCodes_tlv = lspErrorCodes_tlv;
    }

    public RSVPErrorSpecTLV getRsvpErrorSpec_tlv() {
        return this.rsvpErrorSpec_tlv;
    }

    public void setRsvpErrorSpec_tlv(RSVPErrorSpecTLV rsvpErrorSpec_tlv) {
        this.rsvpErrorSpec_tlv = rsvpErrorSpec_tlv;
    }

    public void setLspId(int lspId) {
        this.lspId = lspId;
    }

    public int getOpFlags() {
        return this.opFlags;
    }

    public void setOpFlags(int opFlags) {
        this.opFlags = opFlags;
    }

    public LSPDatabaseVersionTLV getLspDBVersion_tlv() {
        return this.lspDBVersion_tlv;
    }

    public void setLspDBVersion_tlv(LSPDatabaseVersionTLV lspDBVersion_tlv) {
        this.lspDBVersion_tlv = lspDBVersion_tlv;
    }

    public boolean isP2mpFlag() {
        return this.p2mpFlag;
    }

    public void setP2mpFlag(boolean p2mpFlag) {
        this.p2mpFlag = p2mpFlag;
    }

    public boolean isFragmentationFlag() {
        return this.fragmentationFlag;
    }

    public void setFragmentationFlag(boolean fragmentationFlag) {
        this.fragmentationFlag = fragmentationFlag;
    }

    public boolean isEroCompressionFlag() {
        return this.eroCompressionFlag;
    }

    public void setEroCompressionFlag(boolean eroCompressionFlag) {
        this.eroCompressionFlag = eroCompressionFlag;
    }

    public boolean isDelegateFlag() {
        return this.delegateFlag;
    }

    public void setDelegateFlag(boolean delegateFlag) {
        this.delegateFlag = delegateFlag;
    }

    public boolean isSyncFlag() {
        return this.syncFlag;
    }

    public void setSyncFlag(boolean syncFlag) {
        this.syncFlag = syncFlag;
    }

    public boolean isRemoveFlag() {
        return this.removeFlag;
    }

    public void setRemoveFlag(boolean removeFlag) {
        this.removeFlag = removeFlag;
    }

    public boolean isAdministrativeFlag() {
        return this.administrativeFlag;
    }

    public void setAdministrativeFlag(boolean administrativeFlag) {
        this.administrativeFlag = administrativeFlag;
    }

    public boolean isCreateFlag() {
        return this.createFlag;
    }

    public void setCreateFlag(boolean createFlag) {
        this.createFlag = createFlag;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.administrativeFlag ? 1231 : 1237);
        result = 31 * result + (this.createFlag ? 1231 : 1237);
        result = 31 * result + (this.delegateFlag ? 1231 : 1237);
        result = 31 * result + (this.eroCompressionFlag ? 1231 : 1237);
        result = 31 * result + (this.fragmentationFlag ? 1231 : 1237);
        result = 31 * result + (this.lspDBVersion_tlv == null ? 0 : this.lspDBVersion_tlv.hashCode());
        result = 31 * result + (this.lspErrorCodes_tlv == null ? 0 : this.lspErrorCodes_tlv.hashCode());
        result = 31 * result + this.lspId;
        result = 31 * result + (this.lspIdentifiers_tlv == null ? 0 : this.lspIdentifiers_tlv.hashCode());
        result = 31 * result + this.opFlags;
        result = 31 * result + (this.p2mpFlag ? 1231 : 1237);
        result = 31 * result + (this.removeFlag ? 1231 : 1237);
        result = 31 * result + (this.rsvpErrorSpec_tlv == null ? 0 : this.rsvpErrorSpec_tlv.hashCode());
        result = 31 * result + (this.symbolicPathNameTLV_tlv == null ? 0 : this.symbolicPathNameTLV_tlv.hashCode());
        result = 31 * result + (this.syncFlag ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LSP other = (LSP)obj;
        if (this.administrativeFlag != other.administrativeFlag) {
            return false;
        }
        if (this.createFlag != other.createFlag) {
            return false;
        }
        if (this.delegateFlag != other.delegateFlag) {
            return false;
        }
        if (this.eroCompressionFlag != other.eroCompressionFlag) {
            return false;
        }
        if (this.fragmentationFlag != other.fragmentationFlag) {
            return false;
        }
        if (this.lspDBVersion_tlv == null ? other.lspDBVersion_tlv != null : !this.lspDBVersion_tlv.equals(other.lspDBVersion_tlv)) {
            return false;
        }
        if (this.lspErrorCodes_tlv == null ? other.lspErrorCodes_tlv != null : !this.lspErrorCodes_tlv.equals(other.lspErrorCodes_tlv)) {
            return false;
        }
        if (this.lspId != other.lspId) {
            return false;
        }
        if (this.lspIdentifiers_tlv == null ? other.lspIdentifiers_tlv != null : !this.lspIdentifiers_tlv.equals(other.lspIdentifiers_tlv)) {
            return false;
        }
        if (this.opFlags != other.opFlags) {
            return false;
        }
        if (this.p2mpFlag != other.p2mpFlag) {
            return false;
        }
        if (this.removeFlag != other.removeFlag) {
            return false;
        }
        if (this.rsvpErrorSpec_tlv == null ? other.rsvpErrorSpec_tlv != null : !this.rsvpErrorSpec_tlv.equals(other.rsvpErrorSpec_tlv)) {
            return false;
        }
        if (this.symbolicPathNameTLV_tlv == null ? other.symbolicPathNameTLV_tlv != null : !this.symbolicPathNameTLV_tlv.equals(other.symbolicPathNameTLV_tlv)) {
            return false;
        }
        return this.syncFlag == other.syncFlag;
    }

    public String toString() {
        return "LSP [lspId=" + this.lspId + ", delegateFlag=" + this.delegateFlag + ", syncFlag=" + this.syncFlag + ", removeFlag=" + this.removeFlag + ", administrativeFlag=" + this.administrativeFlag + ", opFlags=" + this.opFlags + ", createFlag=" + this.createFlag + ", p2mpFlag=" + this.p2mpFlag + ", fragmentationFlag=" + this.fragmentationFlag + ", eroCompressionFlag=" + this.eroCompressionFlag + ", symbolicPathNameTLV_tlv=" + String.valueOf(this.symbolicPathNameTLV_tlv) + ", lspIdentifiers_tlv=" + String.valueOf(this.lspIdentifiers_tlv) + ", lspErrorCodes_tlv=" + String.valueOf(this.lspErrorCodes_tlv) + ", rsvpErrorSpec_tlv=" + String.valueOf(this.rsvpErrorSpec_tlv) + ", lspDBVersion_tlv=" + String.valueOf(this.lspDBVersion_tlv) + "]";
    }
}

