/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.subobjects.ASNumberXROSubobject;
import es.tid.pce.pcep.objects.subobjects.IPv4PrefixXROSubobject;
import es.tid.pce.pcep.objects.subobjects.IPv6prefixXROSubobject;
import es.tid.pce.pcep.objects.subobjects.SRLGXROSubobject;
import es.tid.pce.pcep.objects.subobjects.UnnumberIfIDXROSubobject;
import es.tid.pce.pcep.objects.subobjects.XROSubobject;
import java.util.LinkedList;

public class ExcludeRouteObject
extends PCEPObject {
    private boolean fail;
    public LinkedList<XROSubobject> XROSubobjectList;

    public ExcludeRouteObject() {
        this.setObjectClass(17);
        this.setOT(1);
        this.XROSubobjectList = new LinkedList();
    }

    public ExcludeRouteObject(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.XROSubobjectList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        int len = 8;
        int k = 0;
        while (k < this.XROSubobjectList.size()) {
            this.XROSubobjectList.get(k).encode();
            len += this.XROSubobjectList.get(k).getErosolength();
            ++k;
        }
        this.ObjectLength = len;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        this.object_bytes[4] = 0;
        this.object_bytes[5] = 0;
        this.object_bytes[6] = 0;
        this.object_bytes[7] = (byte)(this.fail ? 1 : 0);
        int pos = 8;
        int k2 = 0;
        while (k2 < this.XROSubobjectList.size()) {
            System.arraycopy(this.XROSubobjectList.get(k2).getSubobject_bytes(), 0, this.object_bytes, pos, this.XROSubobjectList.get(k2).getErosolength());
            pos += this.XROSubobjectList.get(k2).getErosolength();
            ++k2;
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        boolean fin = false;
        int offset = 8;
        if (this.ObjectLength == 8) {
            fin = true;
        }
        this.fail = (this.object_bytes[7] & 1) == 1;
        while (!fin) {
            int subojectclass = XROSubobject.getType(this.getObject_bytes(), offset);
            int subojectlength = XROSubobject.getLength(this.getObject_bytes(), offset);
            switch (subojectclass) {
                case 1: {
                    IPv4PrefixXROSubobject sobjt4 = new IPv4PrefixXROSubobject(this.getObject_bytes(), offset);
                    this.addXROSubobject(sobjt4);
                    break;
                }
                case 2: {
                    IPv6prefixXROSubobject sobjt6 = new IPv6prefixXROSubobject(this.getObject_bytes(), offset);
                    this.addXROSubobject(sobjt6);
                    break;
                }
                case 32: {
                    ASNumberXROSubobject sobjas = new ASNumberXROSubobject(this.getObject_bytes(), offset);
                    this.addXROSubobject(sobjas);
                    break;
                }
                case 4: {
                    UnnumberIfIDXROSubobject subun = new UnnumberIfIDXROSubobject(this.getObject_bytes(), offset);
                    this.addXROSubobject(subun);
                    break;
                }
                case 34: {
                    SRLGXROSubobject subsrlg = new SRLGXROSubobject(this.getObject_bytes(), offset);
                    this.addXROSubobject(subsrlg);
                    break;
                }
                default: {
                    log.warn("XRO Subobject Unknown");
                    fin = true;
                }
            }
            if ((offset += subojectlength) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public void addXROSubobject(XROSubobject eroso) {
        this.XROSubobjectList.add(eroso);
    }

    public void addEROSubobjectList(LinkedList<XROSubobject> erosovec) {
        this.XROSubobjectList.addAll(erosovec);
    }

    public LinkedList<XROSubobject> getXROSubobjectList() {
        return this.XROSubobjectList;
    }

    public void setXROSubobjectList(LinkedList<XROSubobject> eROSubobjectList) {
        this.XROSubobjectList = eROSubobjectList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.XROSubobjectList.size() * 100);
        sb.append("<XRO: ");
        int i = 0;
        while (i < this.XROSubobjectList.size()) {
            sb.append(this.XROSubobjectList.get(i).toString());
            ++i;
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.XROSubobjectList == null ? 0 : this.XROSubobjectList.hashCode());
        result = 31 * result + (this.fail ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExcludeRouteObject other = (ExcludeRouteObject)obj;
        if (this.XROSubobjectList == null ? other.XROSubobjectList != null : !this.XROSubobjectList.equals(other.XROSubobjectList)) {
            return false;
        }
        return this.fail == other.fail;
    }

    public boolean isFail() {
        return this.fail;
    }

    public void setFail(boolean fail) {
        this.fail = fail;
    }
}

