/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class EndPointsIPv4
extends EndPoints {
    private Inet4Address sourceIP;
    private Inet4Address destIP;

    public EndPointsIPv4() {
        this.setObjectClass(4);
        this.setOT(1);
    }

    public EndPointsIPv4(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 12;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        System.arraycopy(this.sourceIP.getAddress(), 0, this.object_bytes, 4, 4);
        System.arraycopy(this.destIP.getAddress(), 0, this.object_bytes, 8, 4);
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength != 12) {
            throw new MalformedPCEPObjectException();
        }
        byte[] ip = new byte[4];
        System.arraycopy(this.object_bytes, 4, ip, 0, 4);
        try {
            this.sourceIP = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        System.arraycopy(this.object_bytes, 8, ip, 0, 4);
        try {
            this.destIP = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Inet4Address getSourceIP() {
        return this.sourceIP;
    }

    public void setSourceIP(Inet4Address sourceIP) {
        this.sourceIP = sourceIP;
    }

    public Inet4Address getDestIP() {
        return this.destIP;
    }

    public void setDestIP(Inet4Address destIP) {
        this.destIP = destIP;
    }

    public String toString() {
        return "Source IP: " + String.valueOf(this.sourceIP) + " Destination IP: " + String.valueOf(this.destIP);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.destIP == null ? 0 : this.destIP.hashCode());
        result = 31 * result + (this.sourceIP == null ? 0 : this.sourceIP.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndPointsIPv4 other = (EndPointsIPv4)obj;
        if (this.destIP == null ? other.destIP != null : !this.destIP.equals(other.destIP)) {
            return false;
        }
        return !(this.sourceIP == null ? other.sourceIP != null : !this.sourceIP.equals(other.sourceIP));
    }
}

