/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.Association;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.ExtendedAssociationIDTLV;
import es.tid.pce.pcep.objects.tlvs.GlobalAssociationSourceTLV;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.pce.pcep.objects.tlvs.SRPolicyCandidatePathIdentifiersTLV;
import es.tid.pce.pcep.objects.tlvs.SRPolicyCandidatePathNameTLV;
import es.tid.pce.pcep.objects.tlvs.SRPolicyCandidatePathPreferenceTLV;
import es.tid.pce.pcep.objects.tlvs.SRPolicyName;
import es.tid.protocol.commons.ByteHandler;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.Objects;

public class AssociationIPv6
extends Association {
    private boolean removal = false;
    private int assocType = 0;
    private int assocID = 0;
    private Inet6Address associationSource;
    private GlobalAssociationSourceTLV global_association_source_tlv = null;
    private ExtendedAssociationIDTLV extended_ssociation_id_tlv = null;
    private SRPolicyCandidatePathNameTLV sr_policy_candidate_path_tlv = null;
    private SRPolicyCandidatePathIdentifiersTLV sr_policy_candidate_path_identifiers_tlv = null;
    private SRPolicyCandidatePathPreferenceTLV sr_policy_candidate_path_preference_tlv = null;
    private SRPolicyName sr_policy_name = null;

    public AssociationIPv6() {
        this.setObjectClass(40);
        this.setOT(2);
    }

    public AssociationIPv6(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 28;
        if (this.global_association_source_tlv != null) {
            this.global_association_source_tlv.encode();
            this.ObjectLength += this.global_association_source_tlv.getTotalTLVLength();
        }
        if (this.extended_ssociation_id_tlv != null) {
            this.extended_ssociation_id_tlv.encode();
            this.ObjectLength += this.extended_ssociation_id_tlv.getTotalTLVLength();
        }
        if (this.sr_policy_candidate_path_tlv != null) {
            this.sr_policy_candidate_path_tlv.encode();
            this.ObjectLength += this.sr_policy_candidate_path_tlv.getTotalTLVLength();
        }
        if (this.sr_policy_candidate_path_identifiers_tlv != null) {
            this.sr_policy_candidate_path_identifiers_tlv.encode();
            this.ObjectLength += this.sr_policy_candidate_path_identifiers_tlv.getTotalTLVLength();
        }
        if (this.sr_policy_candidate_path_preference_tlv != null) {
            this.sr_policy_candidate_path_preference_tlv.encode();
            this.ObjectLength += this.sr_policy_candidate_path_preference_tlv.getTotalTLVLength();
        }
        if (this.sr_policy_name != null) {
            this.sr_policy_name.encode();
            this.ObjectLength += this.sr_policy_name.getTotalTLVLength();
        }
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        this.object_bytes[4] = 0;
        this.object_bytes[5] = 0;
        this.object_bytes[6] = 0;
        this.object_bytes[7] = (byte)(this.removal ? 1 : 0);
        int offset = 8;
        this.object_bytes[offset] = (byte)(this.assocType >> 8 & 0xFF);
        this.object_bytes[offset + 1] = (byte)(this.assocType & 0xFF);
        this.object_bytes[offset + 2] = (byte)(this.assocID >> 8 & 0xFF);
        this.object_bytes[offset + 3] = (byte)(this.assocID & 0xFF);
        offset = 12;
        System.arraycopy(this.associationSource.getAddress(), 0, this.object_bytes, 12, 16);
        offset += 16;
        if (this.global_association_source_tlv != null) {
            System.arraycopy(this.global_association_source_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.global_association_source_tlv.getTotalTLVLength());
            offset += this.global_association_source_tlv.getTotalTLVLength();
        }
        if (this.extended_ssociation_id_tlv != null) {
            System.arraycopy(this.extended_ssociation_id_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.extended_ssociation_id_tlv.getTotalTLVLength());
            offset += this.extended_ssociation_id_tlv.getTotalTLVLength();
        }
        if (this.sr_policy_candidate_path_tlv != null) {
            System.arraycopy(this.sr_policy_candidate_path_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.sr_policy_candidate_path_tlv.getTotalTLVLength());
            offset += this.sr_policy_candidate_path_tlv.getTotalTLVLength();
        }
        if (this.sr_policy_candidate_path_identifiers_tlv != null) {
            System.arraycopy(this.sr_policy_candidate_path_identifiers_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.sr_policy_candidate_path_identifiers_tlv.getTotalTLVLength());
            offset += this.sr_policy_candidate_path_identifiers_tlv.getTotalTLVLength();
        }
        if (this.sr_policy_candidate_path_preference_tlv != null) {
            System.arraycopy(this.sr_policy_candidate_path_preference_tlv.getTlv_bytes(), 0, this.object_bytes, offset, this.sr_policy_candidate_path_preference_tlv.getTotalTLVLength());
            offset += this.sr_policy_candidate_path_preference_tlv.getTotalTLVLength();
        }
        if (this.sr_policy_name != null) {
            System.arraycopy(this.sr_policy_name.getTlv_bytes(), 0, this.object_bytes, offset, this.sr_policy_name.getTotalTLVLength());
            offset += this.sr_policy_name.getTotalTLVLength();
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        this.removal = (this.object_bytes[7] & 1) == 1;
        int offset = 8;
        this.assocType = ByteHandler.decode2bytesInteger(this.object_bytes, offset);
        this.assocID = ByteHandler.decode2bytesInteger(this.object_bytes, offset + 2);
        byte[] ip = new byte[16];
        System.arraycopy(this.object_bytes, 12, ip, 0, 16);
        try {
            this.associationSource = (Inet6Address)Inet6Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        boolean fin = false;
        if (this.ObjectLength == 16) {
            fin = true;
        }
        offset = 28;
        while (!fin) {
            int tlvtype = PCEPTLV.getType(this.getObject_bytes(), offset);
            int tlvlength = PCEPTLV.getTotalTLVLength(this.getObject_bytes(), offset);
            switch (tlvtype) {
                case 30: {
                    this.global_association_source_tlv = new GlobalAssociationSourceTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 31: {
                    this.extended_ssociation_id_tlv = new ExtendedAssociationIDTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 56: {
                    this.sr_policy_name = new SRPolicyName(this.getObject_bytes(), offset);
                    break;
                }
                case 57: {
                    this.sr_policy_candidate_path_identifiers_tlv = new SRPolicyCandidatePathIdentifiersTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 58: {
                    this.sr_policy_candidate_path_tlv = new SRPolicyCandidatePathNameTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 59: {
                    this.sr_policy_candidate_path_preference_tlv = new SRPolicyCandidatePathPreferenceTLV(this.getObject_bytes(), offset);
                    break;
                }
                default: {
                    log.debug("UNKNOWN TLV found");
                }
            }
            if ((offset += tlvlength) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public boolean isRemoval() {
        return this.removal;
    }

    public void setRemoval(boolean removal) {
        this.removal = removal;
    }

    public int getAssocType() {
        return this.assocType;
    }

    public void setAssocType(int assocType) {
        this.assocType = assocType;
    }

    public int getAssocID() {
        return this.assocID;
    }

    public void setAssocID(int assocID) {
        this.assocID = assocID;
    }

    public Inet6Address getAssociationSource() {
        return this.associationSource;
    }

    public void setAssociationSource(Inet6Address associationSource) {
        this.associationSource = associationSource;
    }

    public GlobalAssociationSourceTLV getGlobal_association_source_tlv() {
        return this.global_association_source_tlv;
    }

    public void setGlobal_association_source_tlv(GlobalAssociationSourceTLV global_association_source_tlv) {
        this.global_association_source_tlv = global_association_source_tlv;
    }

    public ExtendedAssociationIDTLV getExtended_ssociation_id_tlv() {
        return this.extended_ssociation_id_tlv;
    }

    public void setExtended_ssociation_id_tlv(ExtendedAssociationIDTLV extended_ssociation_id_tlv) {
        this.extended_ssociation_id_tlv = extended_ssociation_id_tlv;
    }

    public SRPolicyCandidatePathNameTLV getSr_policy_candidate_path_tlv() {
        return this.sr_policy_candidate_path_tlv;
    }

    public void setSr_policy_candidate_path_tlv(SRPolicyCandidatePathNameTLV sr_policy_candidate_path_tlv) {
        this.sr_policy_candidate_path_tlv = sr_policy_candidate_path_tlv;
    }

    public SRPolicyCandidatePathIdentifiersTLV getSr_policy_candidate_path_identifiers_tlv() {
        return this.sr_policy_candidate_path_identifiers_tlv;
    }

    public void setSr_policy_candidate_path_identifiers_tlv(SRPolicyCandidatePathIdentifiersTLV sr_policy_candidate_path_identifiers_tlv) {
        this.sr_policy_candidate_path_identifiers_tlv = sr_policy_candidate_path_identifiers_tlv;
    }

    public SRPolicyCandidatePathPreferenceTLV getSr_policy_candidate_path_preference_tlv() {
        return this.sr_policy_candidate_path_preference_tlv;
    }

    public void setSr_policy_candidate_path_preference_tlv(SRPolicyCandidatePathPreferenceTLV sr_policy_candidate_path_preference_tlv) {
        this.sr_policy_candidate_path_preference_tlv = sr_policy_candidate_path_preference_tlv;
    }

    public SRPolicyName getSr_policy_name() {
        return this.sr_policy_name;
    }

    public void setSr_policy_name(SRPolicyName sr_policy_name) {
        this.sr_policy_name = sr_policy_name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.assocID, this.assocType, this.associationSource, this.extended_ssociation_id_tlv, this.global_association_source_tlv, this.removal, this.sr_policy_candidate_path_identifiers_tlv, this.sr_policy_candidate_path_preference_tlv, this.sr_policy_candidate_path_tlv, this.sr_policy_name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssociationIPv6 other = (AssociationIPv6)obj;
        return this.assocID == other.assocID && this.assocType == other.assocType && Objects.equals(this.associationSource, other.associationSource) && Objects.equals(this.extended_ssociation_id_tlv, other.extended_ssociation_id_tlv) && Objects.equals(this.global_association_source_tlv, other.global_association_source_tlv) && this.removal == other.removal && Objects.equals(this.sr_policy_candidate_path_identifiers_tlv, other.sr_policy_candidate_path_identifiers_tlv) && Objects.equals(this.sr_policy_candidate_path_preference_tlv, other.sr_policy_candidate_path_preference_tlv) && Objects.equals(this.sr_policy_candidate_path_tlv, other.sr_policy_candidate_path_tlv) && Objects.equals(this.sr_policy_name, other.sr_policy_name);
    }

    public String toString() {
        return "AssociationIPv6 [removal=" + this.removal + ", assocType=" + this.assocType + ", assocID=" + this.assocID + ", associationSource=" + String.valueOf(this.associationSource) + ", global_association_source_tlv=" + String.valueOf(this.global_association_source_tlv) + ", extended_ssociation_id_tlv=" + String.valueOf(this.extended_ssociation_id_tlv) + ", sr_policy_candidate_path_tlv=" + String.valueOf(this.sr_policy_candidate_path_tlv) + ", sr_policy_candidate_path_identifiers_tlv=" + String.valueOf(this.sr_policy_candidate_path_identifiers_tlv) + ", sr_policy_candidate_path_preference_tlv=" + String.valueOf(this.sr_policy_candidate_path_preference_tlv) + ", sr_policy_name=" + String.valueOf(this.sr_policy_name) + "]";
    }
}

