/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.messages;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.UpdateRequest;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.objects.PCEPObject;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPUpdate
extends PCEPMessage {
    private static final Logger log = LoggerFactory.getLogger((String)"PCEPParser");
    protected LinkedList<UpdateRequest> updateRequestList;

    public PCEPUpdate() {
        this.setMessageType(11);
        this.updateRequestList = new LinkedList();
    }

    public PCEPUpdate(byte[] bytes) throws PCEPProtocolViolationException {
        super(bytes);
        this.updateRequestList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int len = 4;
        int index = 0;
        while (index < this.updateRequestList.size()) {
            this.updateRequestList.get(index).encode();
            len += this.updateRequestList.get(index).getLength();
            ++index;
        }
        if (this.updateRequestList.size() == 0) {
            log.warn("There should be at least one update request in a PCEP update Request message");
            throw new PCEPProtocolViolationException();
        }
        this.setMessageLength(len);
        this.messageBytes = new byte[len];
        this.encodeHeader();
        int offset = 4;
        index = 0;
        while (index < this.updateRequestList.size()) {
            System.arraycopy(this.updateRequestList.get(index).getBytes(), 0, this.messageBytes, offset, this.updateRequestList.get(index).getLength());
            offset += this.updateRequestList.get(index).getLength();
            ++index;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void decode() throws PCEPProtocolViolationException {
        offset = 4;
        atLeastOne = false;
        if (PCEPObject.getObjectClass(this.getBytes(), offset) == 33) ** GOTO lbl15
        throw new PCEPProtocolViolationException();
lbl-1000:
        // 1 sources

        {
            try {
                ur = new UpdateRequest(this.getBytes(), offset);
            }
            catch (PCEPProtocolViolationException e) {
                PCEPUpdate.log.warn("Malformed UpdateRequest Construct");
                throw new PCEPProtocolViolationException();
            }
            offset += ur.getLength();
            this.updateRequestList.add(ur);
            atLeastOne = true;
lbl15:
            // 2 sources

            ** while (PCEPObject.getObjectClass((byte[])this.getBytes(), (int)offset) == 33)
        }
lbl16:
        // 1 sources

        if (!atLeastOne) {
            PCEPUpdate.log.warn("Malformed Report Message. There must be at least one update-list object. Exception will be throwed");
            throw new PCEPProtocolViolationException();
        }
    }

    public LinkedList<UpdateRequest> getUpdateRequestList() {
        return this.updateRequestList;
    }

    public void setUpdateRequestList(LinkedList<UpdateRequest> updateRequestList) {
        this.updateRequestList = updateRequestList;
    }

    public void addStateReport(UpdateRequest upRequest) {
        this.updateRequestList.add(upRequest);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.updateRequestList == null ? 0 : this.updateRequestList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPUpdate other = (PCEPUpdate)obj;
        return !(this.updateRequestList == null ? other.updateRequestList != null : !this.updateRequestList.equals(other.updateRequestList));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.updateRequestList.size() * 100);
        sb.append("UPDATE MESSAGE: ");
        int i = 0;
        while (i < this.updateRequestList.size()) {
            sb.append(this.updateRequestList.get(i).toString());
            ++i;
        }
        return sb.toString();
    }
}

