/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.messages;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.objects.PCEPObject;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPResponse
extends PCEPMessage {
    public LinkedList<Response> ResponseList = new LinkedList();
    private static final Logger log = LoggerFactory.getLogger((String)"PCEPParser");

    public PCEPResponse() {
        this.setMessageType(4);
    }

    public PCEPResponse(byte[] bytes) throws PCEPProtocolViolationException {
        super(bytes);
        this.decode();
    }

    public void addResponse(Response response) {
        this.ResponseList.add(response);
    }

    public Response getResponse(int index) {
        return this.ResponseList.get(index);
    }

    public LinkedList<Response> getResponseList() {
        return this.ResponseList;
    }

    public void setResponseList(LinkedList<Response> responseList) {
        this.ResponseList = responseList;
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        if (this.ResponseList.size() == 0) {
            log.warn("There should be at least one request in a PCEP Response message");
            throw new PCEPProtocolViolationException();
        }
        int len = 4;
        int i = 0;
        while (i < this.ResponseList.size()) {
            this.ResponseList.get(i).encode();
            len += this.ResponseList.get(i).getLength();
            ++i;
        }
        this.setMessageLength(len);
        this.messageBytes = new byte[len];
        this.encodeHeader();
        int offset = 4;
        int i2 = 0;
        while (i2 < this.ResponseList.size()) {
            System.arraycopy(this.ResponseList.get(i2).getBytes(), 0, this.messageBytes, offset, this.ResponseList.get(i2).getLength());
            offset += this.ResponseList.get(i2).getLength();
            ++i2;
        }
    }

    public void decode() throws PCEPProtocolViolationException {
        byte[] bytes = this.getBytes();
        int offset = 4;
        while (PCEPObject.getObjectClass(bytes, offset) == 2) {
            Response res = new Response();
            res.decode(bytes, offset);
            this.ResponseList.add(res);
            if ((offset += res.getLength()) < bytes.length) continue;
            return;
        }
        if (this.ResponseList.size() == 0) {
            log.warn("No Responses in the PCEP Response message");
            throw new PCEPProtocolViolationException();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.ResponseList.size() * 100);
        sb.append("RESP: ");
        int i = 0;
        while (i < this.ResponseList.size()) {
            sb.append(this.ResponseList.get(i).toString());
            ++i;
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ResponseList == null ? 0 : this.ResponseList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPResponse other = (PCEPResponse)obj;
        return !(this.ResponseList == null ? other.ResponseList != null : !this.ResponseList.equals(other.ResponseList));
    }
}

