/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.messages;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.objects.PCEPObject;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPReport
extends PCEPMessage {
    private static final Logger log = LoggerFactory.getLogger((String)"PCEPParser");
    protected LinkedList<StateReport> stateReportList;

    public PCEPReport() {
        this.setMessageType(10);
        this.stateReportList = new LinkedList();
    }

    public PCEPReport(byte[] bytes) throws PCEPProtocolViolationException {
        super(bytes);
        this.stateReportList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int len = 4;
        int index = 0;
        while (index < this.stateReportList.size()) {
            this.stateReportList.get(index).encode();
            len += this.stateReportList.get(index).getLength();
            ++index;
        }
        if (this.stateReportList.size() == 0) {
            log.warn("There should be at least one state Report");
            throw new PCEPProtocolViolationException();
        }
        this.setMessageLength(len);
        this.messageBytes = new byte[len];
        this.encodeHeader();
        int offset = 4;
        index = 0;
        while (index < this.stateReportList.size()) {
            System.arraycopy(this.stateReportList.get(index).getBytes(), 0, this.messageBytes, offset, this.stateReportList.get(index).getLength());
            offset += this.stateReportList.get(index).getLength();
            ++index;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void decode() throws PCEPProtocolViolationException {
        offset = 4;
        oc = PCEPObject.getObjectClass(this.getBytes(), offset);
        if (oc == 33 || oc == 32) ** GOTO lbl16
        PCEPReport.log.warn("At least one state-report is needed");
        throw new PCEPProtocolViolationException();
lbl-1000:
        // 1 sources

        {
            try {
                sr = new StateReport(this.getBytes(), offset);
                this.stateReportList.add(sr);
                if ((offset += sr.getLength()) >= this.messageBytes.length) {
                    return;
                }
                continue;
            }
            catch (PCEPProtocolViolationException e) {
                PCEPReport.log.warn("Malformed PCEP Report");
                throw new PCEPProtocolViolationException();
            }
lbl16:
            // 2 sources

            ** while (oc == 33 || oc == 32)
        }
lbl17:
        // 1 sources

    }

    public LinkedList<StateReport> getStateReportList() {
        return this.stateReportList;
    }

    public void setStateReportList(LinkedList<StateReport> updateRequestList) {
        this.stateReportList = updateRequestList;
    }

    public void addStateReport(StateReport stReport) {
        this.stateReportList.add(stReport);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.stateReportList.size() * 100);
        sb.append("PCRpt: ");
        int i = 0;
        while (i < this.stateReportList.size()) {
            sb.append(this.stateReportList.get(i).toString());
            ++i;
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.stateReportList == null ? 0 : this.stateReportList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPReport other = (PCEPReport)obj;
        return !(this.stateReportList == null ? other.stateReportList != null : !this.stateReportList.equals(other.stateReportList));
    }
}

