/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.messages;

import es.tid.pce.pcep.PCEPElement;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PCEPMessage
implements PCEPElement {
    protected byte[] messageBytes;
    private int messageType;
    private int Ver;
    private int Flags;
    private int messageLength;
    protected final Logger log = LoggerFactory.getLogger((String)"PCEPParser");

    public void setMessageLength(int messageLength) {
        this.messageLength = messageLength;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public PCEPMessage() {
        this.Ver = 1;
        this.Flags = 0;
        this.messageLength = 0;
    }

    public PCEPMessage(byte[] bytes) throws PCEPProtocolViolationException {
        this.messageLength = (bytes[2] & 0xFF) * 256 + (bytes[3] & 0xFF);
        if (bytes.length != this.getLength()) {
            this.log.warn("Bytes and length in header do not match");
            throw new PCEPProtocolViolationException();
        }
        this.messageBytes = new byte[this.messageLength];
        System.arraycopy(bytes, 0, this.messageBytes, 0, this.messageLength);
        this.messageType = this.messageBytes[1] & 0xFF;
        this.Ver = (this.messageBytes[0] & 0xE0) >>> 5;
    }

    @Override
    public byte[] getBytes() {
        return this.messageBytes;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public static int getMessageType(byte[] bytes) {
        byte mt = bytes[1];
        return mt;
    }

    public int getVer() {
        return this.Ver;
    }

    @Override
    public int getLength() {
        return this.messageLength;
    }

    protected void encodeHeader() {
        this.messageBytes[0] = (byte)(this.Ver << 5 & 0xE0 | this.Flags & 0x1F);
        this.messageBytes[1] = (byte)this.messageType;
        this.messageBytes[2] = (byte)(this.messageLength >> 8 & 0xFF);
        this.messageBytes[3] = (byte)(this.messageLength & 0xFF);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.Flags;
        result = 31 * result + this.Ver;
        result = 31 * result + Arrays.hashCode(this.messageBytes);
        result = 31 * result + this.messageLength;
        result = 31 * result + this.messageType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPMessage other = (PCEPMessage)obj;
        if (this.Flags != other.Flags) {
            return false;
        }
        if (this.Ver != other.Ver) {
            return false;
        }
        if (!Arrays.equals(this.messageBytes, other.messageBytes)) {
            return false;
        }
        if (this.messageLength != other.messageLength) {
            return false;
        }
        return this.messageType == other.messageType;
    }
}

