/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.ObjectiveFunction;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.Svec;
import java.util.LinkedList;

public class SVECConstruct
extends PCEPConstruct {
    private Svec svec;
    private LinkedList<ObjectiveFunction> objectiveFunctionList;
    private LinkedList<Metric> metricList;

    public SVECConstruct() {
        this.metricList = new LinkedList();
        this.objectiveFunctionList = new LinkedList();
    }

    public SVECConstruct(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.objectiveFunctionList = new LinkedList();
        this.metricList = new LinkedList();
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int i;
        int i2;
        int len = 0;
        if (this.svec != null) {
            this.svec.encode();
            len += this.svec.getLength();
        } else {
            log.warn("svec  not found!  compulsory");
            throw new PCEPProtocolViolationException();
        }
        if (this.objectiveFunctionList != null) {
            i2 = 0;
            while (i2 < this.objectiveFunctionList.size()) {
                this.objectiveFunctionList.get(i2).encode();
                len += this.objectiveFunctionList.get(i2).getLength();
                ++i2;
            }
        }
        if (this.metricList != null) {
            i2 = 0;
            while (i2 < this.metricList.size()) {
                this.metricList.get(i2).encode();
                len += this.metricList.get(i2).getLength();
                ++i2;
            }
        }
        this.setLength(len);
        this.bytes = new byte[len];
        int offset = 0;
        System.arraycopy(this.svec.getBytes(), 0, this.bytes, offset, this.svec.getLength());
        offset += this.svec.getLength();
        if (this.objectiveFunctionList != null) {
            i = 0;
            while (i < this.objectiveFunctionList.size()) {
                System.arraycopy(this.objectiveFunctionList.get(i).getBytes(), 0, this.bytes, offset, this.objectiveFunctionList.get(i).getLength());
                offset += this.objectiveFunctionList.get(i).getLength();
                ++i;
            }
        }
        if (this.metricList != null) {
            i = 0;
            while (i < this.metricList.size()) {
                System.arraycopy(this.metricList.get(i).getBytes(), 0, this.bytes, offset, this.metricList.get(i).getLength());
                offset += this.metricList.get(i).getLength();
                ++i;
            }
        }
    }

    public void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int len = 0;
        int oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 11) {
            try {
                this.svec = new Svec(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed RP Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.svec.getLength();
        } else {
            log.warn("SVEC Construct must start with SVEC object");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset += this.svec.getLength());
        while (oc == 21) {
            ObjectiveFunction objectiveFunction = new ObjectiveFunction();
            try {
                objectiveFunction = new ObjectiveFunction(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed OBJECTIVE FUNCTION Object found");
                throw new PCEPProtocolViolationException();
            }
            this.objectiveFunctionList.add(objectiveFunction);
            len += objectiveFunction.getLength();
            oc = PCEPObject.getObjectClass(bytes, offset += objectiveFunction.getLength());
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 6) {
            Metric metric;
            try {
                metric = new Metric(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed METRIC Object found");
                throw new PCEPProtocolViolationException();
            }
            this.metricList.add(metric);
            len += metric.getLength();
            oc = PCEPObject.getObjectClass(bytes, offset += metric.getLength());
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        this.setLength(len);
    }

    public Svec getSvec() {
        return this.svec;
    }

    public void setSvec(Svec svec) {
        this.svec = svec;
    }

    public ObjectiveFunction getObjectiveFunction() {
        return this.objectiveFunctionList.getFirst();
    }

    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.objectiveFunctionList.add(objectiveFunction);
    }

    public LinkedList<ObjectiveFunction> getObjectiveFunctionList() {
        return this.objectiveFunctionList;
    }

    public void setObjectiveFunctionList(LinkedList<ObjectiveFunction> objectiveFunctionList) {
        this.objectiveFunctionList = objectiveFunctionList;
    }

    public LinkedList<Metric> getMetricList() {
        return this.metricList;
    }

    public void setMetricList(LinkedList<Metric> metricList) {
        this.metricList = metricList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.svec != null) {
            sb.append(this.svec.toString());
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.metricList == null ? 0 : this.metricList.hashCode());
        result = 31 * result + (this.objectiveFunctionList == null ? 0 : this.objectiveFunctionList.hashCode());
        result = 31 * result + (this.svec == null ? 0 : this.svec.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SVECConstruct other = (SVECConstruct)obj;
        if (this.metricList == null ? other.metricList != null : !this.metricList.equals(other.metricList)) {
            return false;
        }
        if (this.objectiveFunctionList == null ? other.objectiveFunctionList != null : !this.objectiveFunctionList.equals(other.objectiveFunctionList)) {
            return false;
        }
        return !(this.svec == null ? other.svec != null : !this.svec.equals(other.svec));
    }
}

