/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.constructs.RROBandwidth;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthExistingLSP;
import es.tid.pce.pcep.objects.BandwidthExistingLSPGeneralizedBandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.BandwidthRequestedGeneralizedBandwidth;
import es.tid.pce.pcep.objects.BandwidthUtilization;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.EndPointsIPv6;
import es.tid.pce.pcep.objects.EndPointsUnnumberedIntf;
import es.tid.pce.pcep.objects.ExcludeRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.IncludeRouteObject;
import es.tid.pce.pcep.objects.InterLayer;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.LSPA;
import es.tid.pce.pcep.objects.LoadBalancing;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.ObjectiveFunction;
import es.tid.pce.pcep.objects.P2MPEndPointsIPv4;
import es.tid.pce.pcep.objects.P2PGeneralizedEndPoints;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.ReqAdapCap;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.Reservation;
import es.tid.pce.pcep.objects.SwitchLayer;
import java.util.LinkedList;
import java.util.Objects;

public class Request
extends PCEPConstruct {
    private RequestParameters requestParameters;
    private EndPoints endPoints;
    private LSPA lSPA;
    private Bandwidth bandwidth;
    private LinkedList<BandwidthUtilization> buList;
    private LinkedList<Metric> metricList = new LinkedList();
    private RROBandwidth rROBandwidth;
    private IncludeRouteObject iRO;
    private LoadBalancing loadBalancing;
    private ObjectiveFunction objectiveFunction;
    private ExcludeRouteObject xro;
    private InterLayer interLayer;
    private SwitchLayer switchLayer;
    private ReqAdapCap reqAdapCap;
    private LSP lsp;
    private Reservation reservation;

    public Request() {
        this.buList = new LinkedList();
    }

    public Request(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.buList = new LinkedList();
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int i;
        int i2;
        int len = 0;
        if (this.requestParameters != null) {
            this.requestParameters.encode();
            len += this.requestParameters.getLength();
        } else {
            log.warn("Request Parameters not found! They are compulsory");
            throw new PCEPProtocolViolationException();
        }
        if (this.endPoints != null) {
            this.endPoints.encode();
            len += this.endPoints.getLength();
        } else {
            log.warn("EndPoints not found! They are compulsory");
            throw new PCEPProtocolViolationException();
        }
        if (this.lsp != null) {
            this.lsp.encode();
            len += this.lsp.getLength();
        }
        if (this.lSPA != null) {
            this.lSPA.encode();
            len += this.lSPA.getLength();
        }
        if (this.bandwidth != null) {
            this.bandwidth.encode();
            len += this.bandwidth.getLength();
        }
        if (this.buList != null) {
            i2 = 0;
            while (i2 < this.buList.size()) {
                this.buList.get(i2).encode();
                len += this.buList.get(i2).getLength();
                ++i2;
            }
        }
        if (this.metricList != null) {
            i2 = 0;
            while (i2 < this.metricList.size()) {
                this.metricList.get(i2).encode();
                len += this.metricList.get(i2).getLength();
                ++i2;
            }
        }
        if (this.objectiveFunction != null) {
            this.objectiveFunction.encode();
            len += this.objectiveFunction.getLength();
        }
        if (this.reservation != null) {
            this.reservation.encode();
            len += this.reservation.getLength();
        }
        if (this.rROBandwidth != null) {
            this.rROBandwidth.encode();
            len += this.rROBandwidth.getLength();
        }
        if (this.iRO != null) {
            this.iRO.encode();
            len += this.iRO.getLength();
        }
        if (this.loadBalancing != null) {
            this.loadBalancing.encode();
            len += this.loadBalancing.getLength();
        }
        if (this.xro != null) {
            this.xro.encode();
            len += this.xro.getLength();
        }
        if (this.interLayer != null) {
            this.interLayer.encode();
            len += this.interLayer.getLength();
        }
        if (this.switchLayer != null) {
            this.switchLayer.encode();
            len += this.switchLayer.getLength();
        }
        if (this.reqAdapCap != null) {
            this.reqAdapCap.encode();
            len += this.reqAdapCap.getLength();
        }
        this.setLength(len);
        this.bytes = new byte[len];
        int offset = 0;
        System.arraycopy(this.requestParameters.getBytes(), 0, this.bytes, offset, this.requestParameters.getLength());
        System.arraycopy(this.endPoints.getBytes(), 0, this.bytes, offset += this.requestParameters.getLength(), this.endPoints.getLength());
        offset += this.endPoints.getLength();
        if (this.lsp != null) {
            System.arraycopy(this.lsp.getBytes(), 0, this.bytes, offset, this.lsp.getLength());
            offset += this.lsp.getLength();
        }
        if (this.lSPA != null) {
            System.arraycopy(this.lSPA.getBytes(), 0, this.bytes, offset, this.lSPA.getLength());
            offset += this.lSPA.getLength();
        }
        if (this.bandwidth != null) {
            System.arraycopy(this.bandwidth.getBytes(), 0, this.bytes, offset, this.bandwidth.getLength());
            offset += this.bandwidth.getLength();
        }
        if (this.buList != null) {
            i = 0;
            while (i < this.buList.size()) {
                System.arraycopy(this.buList.get(i).getBytes(), 0, this.bytes, offset, this.buList.get(i).getLength());
                offset += this.buList.get(i).getLength();
                ++i;
            }
        }
        if (this.metricList != null) {
            i = 0;
            while (i < this.metricList.size()) {
                System.arraycopy(this.metricList.get(i).getBytes(), 0, this.bytes, offset, this.metricList.get(i).getLength());
                offset += this.metricList.get(i).getLength();
                ++i;
            }
        }
        if (this.objectiveFunction != null) {
            System.arraycopy(this.objectiveFunction.getBytes(), 0, this.bytes, offset, this.objectiveFunction.getLength());
            offset += this.objectiveFunction.getLength();
        }
        if (this.reservation != null) {
            System.arraycopy(this.reservation.getBytes(), 0, this.bytes, offset, this.reservation.getLength());
            offset += this.reservation.getLength();
        }
        if (this.rROBandwidth != null) {
            System.arraycopy(this.rROBandwidth.getBytes(), 0, this.bytes, offset, this.rROBandwidth.getLength());
            offset += this.rROBandwidth.getLength();
        }
        if (this.iRO != null) {
            System.arraycopy(this.iRO.getBytes(), 0, this.bytes, offset, this.iRO.getLength());
            offset += this.iRO.getLength();
        }
        if (this.loadBalancing != null) {
            System.arraycopy(this.loadBalancing.getBytes(), 0, this.bytes, offset, this.loadBalancing.getLength());
            offset += this.loadBalancing.getLength();
        }
        if (this.xro != null) {
            System.arraycopy(this.xro.getBytes(), 0, this.bytes, offset, this.xro.getLength());
            offset += this.xro.getLength();
        }
        if (this.interLayer != null) {
            System.arraycopy(this.interLayer.getBytes(), 0, this.bytes, offset, this.interLayer.getLength());
            offset += this.interLayer.getLength();
        }
        if (this.switchLayer != null) {
            System.arraycopy(this.switchLayer.getBytes(), 0, this.bytes, offset, this.switchLayer.getLength());
            offset += this.switchLayer.getLength();
        }
        if (this.reqAdapCap != null) {
            System.arraycopy(this.reqAdapCap.getBytes(), 0, this.bytes, offset, this.reqAdapCap.getLength());
            offset += this.reqAdapCap.getLength();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        len = 0;
        max_offset = bytes.length;
        if (offset >= max_offset) {
            Request.log.warn("Empty Request construct!!!");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        ot = PCEPObject.getObjectType(bytes, offset);
        if (oc == 2) {
            try {
                this.requestParameters = new RequestParameters(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed RP Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.requestParameters.getLength();
            if ((offset += this.requestParameters.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        } else {
            Request.log.warn("Request must start with RP object");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 4) {
            ot = PCEPObject.getObjectType(bytes, offset);
            Request.log.debug("Request: ot = " + ot);
            if (ot == 5) {
                try {
                    endPointType = GeneralizedEndPoints.getGeneralizedEndPointsType(bytes, offset);
                    if (endPointType != 1) ** GOTO lbl65
                    this.endPoints = new P2PGeneralizedEndPoints(bytes, offset);
                }
                catch (MalformedPCEPObjectException e) {
                    Request.log.warn("Malformed GENERALIZED END POINTS Object found");
                    throw new PCEPProtocolViolationException();
                }
            } else if (ot == 3) {
                try {
                    this.endPoints = new P2MPEndPointsIPv4(bytes, offset);
                }
                catch (MalformedPCEPObjectException e) {
                    Request.log.warn("Malformed P2MP ENDPOINTS DataPathID Object found");
                    throw new PCEPProtocolViolationException();
                }
            } else if (ot == 1) {
                try {
                    this.endPoints = new EndPointsIPv4(bytes, offset);
                }
                catch (MalformedPCEPObjectException e) {
                    Request.log.warn("Malformed ENDPOINTS IPV4 Object found");
                    throw new PCEPProtocolViolationException();
                }
            } else if (ot == 10) {
                try {
                    this.endPoints = new EndPointsUnnumberedIntf(bytes, offset);
                }
                catch (MalformedPCEPObjectException e) {
                    Request.log.warn("Malformed ENDPOINTS Unnumbered Interface Object found");
                    throw new PCEPProtocolViolationException();
                }
            } else if (ot == 2) {
                try {
                    this.endPoints = new EndPointsIPv6(bytes, offset);
                }
                catch (MalformedPCEPObjectException e) {
                    Request.log.warn("Malformed ENDPOINTSIPV6 Object found");
                    throw new PCEPProtocolViolationException();
                }
            } else {
                Request.log.warn("END POINT TYPE NOT SUPPORTED");
                throw new PCEPProtocolViolationException();
            }
lbl65:
            // 6 sources

            len += this.endPoints.getLength();
            if ((offset += this.endPoints.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        } else {
            Request.log.warn("ENDPOINTS COMPULSORY AFTER  RP object");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 32) {
            try {
                this.lsp = new LSP(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed LSPA Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.lsp.getLength();
            if ((offset += this.lsp.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 9) {
            try {
                this.lSPA = new LSPA(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed LSPA Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.lSPA.getLength();
            if ((offset += this.lSPA.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        try {
            oc = PCEPObject.getObjectClass(bytes, offset);
            ot = PCEPObject.getObjectType(bytes, offset);
            if (oc == 5) {
                if (ot == 1) {
                    this.bandwidth = new BandwidthRequested(bytes, offset);
                } else if (ot == 2) {
                    this.bandwidth = new BandwidthExistingLSP(bytes, offset);
                } else if (ot == 3) {
                    this.bandwidth = new BandwidthRequestedGeneralizedBandwidth(bytes, offset);
                } else if (ot == 4) {
                    this.bandwidth = new BandwidthExistingLSPGeneralizedBandwidth(bytes, offset);
                } else {
                    Request.log.warn("Malformed BANDWIDTH Object found");
                    throw new PCEPProtocolViolationException();
                }
                len += this.bandwidth.getLength();
                if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                    this.setLength(len);
                    return;
                }
            }
        }
        catch (MalformedPCEPObjectException e) {
            Request.log.warn("Malformed BANDWIDTH Object found");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 35) {
            try {
                bu = new BandwidthUtilization(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed BU Object found");
                throw new PCEPProtocolViolationException();
            }
            this.buList.add(bu);
            len += bu.getLength();
            if ((offset += bu.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 6) {
            try {
                metric = new Metric(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed METRIC Object found");
                throw new PCEPProtocolViolationException();
            }
            this.metricList.add(metric);
            len += metric.getLength();
            if ((offset += metric.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 21) {
            try {
                this.objectiveFunction = new ObjectiveFunction(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed OBJECTIVE FUNCTION Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.objectiveFunction.getLength();
            if ((offset += this.objectiveFunction.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 160) {
            try {
                this.reservation = new Reservation(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed OBJECTIVE FUNCTION Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.reservation.getLength();
            if ((offset += this.reservation.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 8) {
            this.rROBandwidth = new RROBandwidth(bytes, offset);
            len += this.rROBandwidth.getLength();
            if ((offset += this.rROBandwidth.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 10) {
            try {
                this.iRO = new IncludeRouteObject(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed IRO Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.iRO.getLength();
            if ((offset += this.iRO.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 14) {
            try {
                this.loadBalancing = new LoadBalancing(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed LOADBALANCING Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.loadBalancing.getLength();
            if ((offset += this.loadBalancing.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 17) {
            try {
                this.xro = new ExcludeRouteObject(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed XRO Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.xro.getLength();
            if ((offset += this.xro.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 36) {
            try {
                this.interLayer = new InterLayer(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed INTER_LAYER Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.interLayer.getLength();
            if ((offset += this.interLayer.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 37) {
            try {
                this.switchLayer = new SwitchLayer(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed SWITCH_LAYER Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.switchLayer.getLength();
            if ((offset += this.switchLayer.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 38) {
            try {
                this.reqAdapCap = new ReqAdapCap(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                Request.log.warn("Malformed ReqAdapCap Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.reqAdapCap.getLength();
            if ((offset += this.reqAdapCap.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        this.setLength(len);
    }

    public RequestParameters getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(RequestParameters requestParameters) {
        this.requestParameters = requestParameters;
    }

    public EndPoints getEndPoints() {
        return this.endPoints;
    }

    public void setEndPoints(EndPoints endPoints) {
        this.endPoints = endPoints;
    }

    public LSPA getLSPA() {
        return this.lSPA;
    }

    public void setLSPA(LSPA lSPA) {
        this.lSPA = lSPA;
    }

    public Bandwidth getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(Bandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    public LinkedList<Metric> getMetricList() {
        return this.metricList;
    }

    public void setMetricList(LinkedList<Metric> metricList) {
        this.metricList = metricList;
    }

    public RROBandwidth getRROBandwidth() {
        return this.rROBandwidth;
    }

    public void setRROBandwidth(RROBandwidth rROBandwidth) {
        this.rROBandwidth = rROBandwidth;
    }

    public IncludeRouteObject getIRO() {
        return this.iRO;
    }

    public void setIRO(IncludeRouteObject iRO) {
        this.iRO = iRO;
    }

    public LoadBalancing getLoadBalancing() {
        return this.loadBalancing;
    }

    public void setLoadBalancing(LoadBalancing loadBalancing) {
        this.loadBalancing = loadBalancing;
    }

    public ObjectiveFunction getObjectiveFunction() {
        return this.objectiveFunction;
    }

    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.objectiveFunction = objectiveFunction;
    }

    public ExcludeRouteObject getXro() {
        return this.xro;
    }

    public void setXro(ExcludeRouteObject xro) {
        this.xro = xro;
    }

    public Reservation getReservation() {
        return this.reservation;
    }

    public void setReservation(Reservation reservation) {
        this.reservation = reservation;
    }

    public InterLayer getInterLayer() {
        return this.interLayer;
    }

    public void setInterLayer(InterLayer interLayer) {
        this.interLayer = interLayer;
    }

    public SwitchLayer getSwitchLayer() {
        return this.switchLayer;
    }

    public void setSwitchLayer(SwitchLayer switchLayer) {
        this.switchLayer = switchLayer;
    }

    public ReqAdapCap getReqAdapCap() {
        return this.reqAdapCap;
    }

    public void setReqAdapCap(ReqAdapCap reqAdapCap) {
        this.reqAdapCap = reqAdapCap;
    }

    public LinkedList<BandwidthUtilization> getBuList() {
        return this.buList;
    }

    public void setBuList(LinkedList<BandwidthUtilization> buList) {
        this.buList = buList;
    }

    public Request duplicate() {
        Request req = new Request();
        req.setRequestParameters(this.requestParameters);
        req.setEndPoints(this.endPoints);
        req.setLSPA(this.lSPA);
        req.setBandwidth(this.bandwidth);
        req.setMetricList(this.metricList);
        req.setRROBandwidth(this.rROBandwidth);
        req.setIRO(this.iRO);
        req.setLoadBalancing(this.loadBalancing);
        req.setObjectiveFunction(this.objectiveFunction);
        req.setXro(this.xro);
        req.setInterLayer(this.interLayer);
        req.setSwitchLayer(this.switchLayer);
        req.setReservation(this.reservation);
        return req;
    }

    public LSP getLsp() {
        return this.lsp;
    }

    public void setLsp(LSP lsp) {
        this.lsp = lsp;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.bandwidth, this.buList, this.endPoints, this.iRO, this.interLayer, this.lSPA, this.loadBalancing, this.lsp, this.metricList, this.objectiveFunction, this.rROBandwidth, this.reqAdapCap, this.requestParameters, this.reservation, this.switchLayer, this.xro);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Request other = (Request)obj;
        return Objects.equals(this.bandwidth, other.bandwidth) && Objects.equals(this.buList, other.buList) && Objects.equals(this.endPoints, other.endPoints) && Objects.equals(this.iRO, other.iRO) && Objects.equals(this.interLayer, other.interLayer) && Objects.equals(this.lSPA, other.lSPA) && Objects.equals(this.loadBalancing, other.loadBalancing) && Objects.equals(this.lsp, other.lsp) && Objects.equals(this.metricList, other.metricList) && Objects.equals(this.objectiveFunction, other.objectiveFunction) && Objects.equals(this.rROBandwidth, other.rROBandwidth) && Objects.equals(this.reqAdapCap, other.reqAdapCap) && Objects.equals(this.requestParameters, other.requestParameters) && Objects.equals(this.reservation, other.reservation) && Objects.equals(this.switchLayer, other.switchLayer) && Objects.equals(this.xro, other.xro);
    }

    public String toString() {
        return "Request [requestParameters=" + String.valueOf(this.requestParameters) + ", endPoints=" + String.valueOf(this.endPoints) + ", lSPA=" + String.valueOf(this.lSPA) + ", bandwidth=" + String.valueOf(this.bandwidth) + ", buList=" + String.valueOf(this.buList) + ", metricList=" + String.valueOf(this.metricList) + ", rROBandwidth=" + String.valueOf(this.rROBandwidth) + ", iRO=" + String.valueOf(this.iRO) + ", loadBalancing=" + String.valueOf(this.loadBalancing) + ", objectiveFunction=" + String.valueOf(this.objectiveFunction) + ", xro=" + String.valueOf(this.xro) + ", interLayer=" + String.valueOf(this.interLayer) + ", switchLayer=" + String.valueOf(this.switchLayer) + ", reqAdapCap=" + String.valueOf(this.reqAdapCap) + ", lsp=" + String.valueOf(this.lsp) + ", reservation=" + String.valueOf(this.reservation) + "]";
    }
}

