/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthExistingLSP;
import es.tid.pce.pcep.objects.BandwidthExistingLSPGeneralizedBandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.BandwidthRequestedGeneralizedBandwidth;
import es.tid.pce.pcep.objects.BandwidthUtilization;
import es.tid.pce.pcep.objects.BitmapLabelSet;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.IncludeRouteObject;
import es.tid.pce.pcep.objects.InterLayer;
import es.tid.pce.pcep.objects.LSPA;
import es.tid.pce.pcep.objects.LabelSet;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.ObjectiveFunction;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.ReportedRouteObject;
import es.tid.pce.pcep.objects.ReqAdapCap;
import es.tid.pce.pcep.objects.ServerIndication;
import es.tid.pce.pcep.objects.SuggestedLabel;
import es.tid.pce.pcep.objects.SwitchLayer;
import java.util.LinkedList;
import java.util.Objects;

public class Path
extends PCEPConstruct {
    private ExplicitRouteObject ero;
    private Bandwidth actual_bandwidth;
    private LinkedList<Metric> actual_metricList;
    private ReportedRouteObject actual_path;
    private ObjectiveFunction of;
    private LSPA lspa;
    private Bandwidth bandwidth;
    private LinkedList<BandwidthUtilization> buList;
    private LinkedList<Metric> metricList = new LinkedList();
    private IncludeRouteObject iro;
    private InterLayer interLayer;
    private SwitchLayer switchLayer;
    private ReqAdapCap reqAdapCap;
    private ServerIndication serverIndication;
    private LabelSet labelSet;
    private SuggestedLabel suggestedLabel;

    public Path() {
        this.actual_metricList = new LinkedList();
        this.buList = new LinkedList();
    }

    public Path(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.actual_metricList = new LinkedList();
        this.buList = new LinkedList();
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int len = 0;
        if (this.ero != null) {
            this.ero.encode();
            len += this.ero.getLength();
        } else {
            log.warn("Path must start with ERO object");
            throw new PCEPProtocolViolationException();
        }
        if (this.actual_bandwidth != null) {
            this.actual_bandwidth.encode();
            len += this.actual_bandwidth.getLength();
        }
        int i = 0;
        while (i < this.actual_metricList.size()) {
            this.actual_metricList.get(i).encode();
            len += this.actual_metricList.get(i).getLength();
            ++i;
        }
        if (this.actual_path != null) {
            this.actual_path.encode();
            len += this.actual_path.getLength();
        }
        if (this.of != null) {
            this.of.encode();
            len += this.of.getLength();
        }
        if (this.lspa != null) {
            this.lspa.encode();
            len += this.lspa.getLength();
        }
        if (this.bandwidth != null) {
            this.bandwidth.encode();
            len += this.bandwidth.getLength();
        }
        if (this.buList != null) {
            i = 0;
            while (i < this.buList.size()) {
                this.buList.get(i).encode();
                len += this.buList.get(i).getLength();
                ++i;
            }
        }
        i = 0;
        while (i < this.metricList.size()) {
            this.metricList.get(i).encode();
            len += this.metricList.get(i).getLength();
            ++i;
        }
        if (this.iro != null) {
            this.iro.encode();
            len += this.iro.getLength();
        }
        if (this.interLayer != null) {
            this.interLayer.encode();
            len += this.interLayer.getLength();
        }
        if (this.switchLayer != null) {
            this.switchLayer.encode();
            len += this.switchLayer.getLength();
        }
        if (this.reqAdapCap != null) {
            this.reqAdapCap.encode();
            len += this.reqAdapCap.getLength();
        }
        if (this.serverIndication != null) {
            this.serverIndication.encode();
            len += this.serverIndication.getLength();
        }
        if (this.labelSet != null) {
            this.labelSet.encode();
            len += this.labelSet.getLength();
        }
        if (this.suggestedLabel != null) {
            this.suggestedLabel.encode();
            len += this.suggestedLabel.getLength();
        }
        this.setLength(len);
        this.bytes = new byte[len];
        int offset = 0;
        if (this.ero != null) {
            System.arraycopy(this.ero.getBytes(), 0, this.bytes, offset, this.ero.getLength());
            offset += this.ero.getLength();
        }
        if (this.actual_bandwidth != null) {
            System.arraycopy(this.actual_bandwidth.getBytes(), 0, this.bytes, offset, this.actual_bandwidth.getLength());
            offset += this.actual_bandwidth.getLength();
        }
        int i2 = 0;
        while (i2 < this.actual_metricList.size()) {
            System.arraycopy(this.actual_metricList.get(i2).getBytes(), 0, this.bytes, offset, this.actual_metricList.get(i2).getLength());
            offset += this.actual_metricList.get(i2).getLength();
            ++i2;
        }
        if (this.actual_path != null) {
            System.arraycopy(this.actual_path.getBytes(), 0, this.bytes, offset, this.actual_path.getLength());
            offset += this.actual_path.getLength();
        }
        if (this.of != null) {
            System.arraycopy(this.of.getBytes(), 0, this.bytes, offset, this.of.getLength());
            offset += this.of.getLength();
        }
        if (this.lspa != null) {
            System.arraycopy(this.lspa.getBytes(), 0, this.bytes, offset, this.lspa.getLength());
            offset += this.lspa.getLength();
        }
        if (this.bandwidth != null) {
            System.arraycopy(this.bandwidth.getBytes(), 0, this.bytes, offset, this.bandwidth.getLength());
            offset += this.bandwidth.getLength();
        }
        if (this.buList != null) {
            i2 = 0;
            while (i2 < this.buList.size()) {
                System.arraycopy(this.buList.get(i2).getBytes(), 0, this.bytes, offset, this.buList.get(i2).getLength());
                offset += this.buList.get(i2).getLength();
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < this.metricList.size()) {
            System.arraycopy(this.metricList.get(i2).getBytes(), 0, this.bytes, offset, this.metricList.get(i2).getLength());
            offset += this.metricList.get(i2).getLength();
            ++i2;
        }
        if (this.iro != null) {
            System.arraycopy(this.iro.getBytes(), 0, this.bytes, offset, this.iro.getLength());
            offset += this.iro.getLength();
        }
        if (this.interLayer != null) {
            System.arraycopy(this.interLayer.getBytes(), 0, this.bytes, offset, this.interLayer.getLength());
            offset += this.interLayer.getLength();
        }
        if (this.switchLayer != null) {
            System.arraycopy(this.switchLayer.getBytes(), 0, this.bytes, offset, this.switchLayer.getLength());
            offset += this.switchLayer.getLength();
        }
        if (this.reqAdapCap != null) {
            System.arraycopy(this.reqAdapCap.getBytes(), 0, this.bytes, offset, this.reqAdapCap.getLength());
            offset += this.reqAdapCap.getLength();
        }
        if (this.serverIndication != null) {
            System.arraycopy(this.serverIndication.getBytes(), 0, this.bytes, offset, this.serverIndication.getLength());
            offset += this.serverIndication.getLength();
        }
        if (this.labelSet != null) {
            System.arraycopy(this.labelSet.getBytes(), 0, this.bytes, offset, this.labelSet.getLength());
            offset += this.labelSet.getLength();
        }
        if (this.suggestedLabel != null) {
            System.arraycopy(this.suggestedLabel.getBytes(), 0, this.bytes, offset, this.suggestedLabel.getLength());
            offset += this.suggestedLabel.getLength();
        }
    }

    private void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int len = 0;
        int oc = PCEPObject.getObjectClass(bytes, offset);
        int ot = PCEPObject.getObjectType(bytes, offset);
        log.info("Checking Intended Path: looking for ERO");
        if (oc == 7) {
            try {
                this.ero = new ExplicitRouteObject(bytes, offset);
            }
            catch (MalformedPCEPObjectException malformedPCEPObjectException) {
                // empty catch block
            }
            offset += this.ero.getLength();
            len += this.ero.getLength();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        ot = PCEPObject.getObjectType(bytes, offset);
        log.info("Checking for actual bandwidth: looking for BANDWIDTH");
        try {
            oc = PCEPObject.getObjectClass(bytes, offset);
            ot = PCEPObject.getObjectType(bytes, offset);
            if (oc == 5) {
                if (ot == 1) {
                    this.bandwidth = new BandwidthRequested(bytes, offset);
                    len += this.bandwidth.getLength();
                    if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                        this.setLength(len);
                        return;
                    }
                } else if (ot == 2) {
                    this.bandwidth = new BandwidthExistingLSP(bytes, offset);
                    len += this.bandwidth.getLength();
                    if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                        this.setLength(len);
                        return;
                    }
                } else if (ot == 3) {
                    this.bandwidth = new BandwidthRequestedGeneralizedBandwidth(bytes, offset);
                    len += this.bandwidth.getLength();
                    if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                        this.setLength(len);
                        return;
                    }
                } else if (ot == 4) {
                    this.bandwidth = new BandwidthExistingLSPGeneralizedBandwidth(bytes, offset);
                    len += this.bandwidth.getLength();
                    if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                        this.setLength(len);
                        return;
                    }
                } else {
                    log.warn("Non standard bandwidth");
                    int bw_length = PCEPObject.getObjectLength(bytes, offset);
                    len += bw_length;
                    if ((offset += bw_length) >= bytes.length) {
                        this.setLength(len);
                        return;
                    }
                }
            }
        }
        catch (MalformedPCEPObjectException e) {
            log.warn("Malformed BANDWIDTH Object found");
            throw new PCEPProtocolViolationException();
        }
        if (PCEPObject.getObjectClass(bytes, offset) == 5) {
            int bw_length = PCEPObject.getObjectLength(bytes, offset);
            len += bw_length;
            if ((offset += bw_length) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        log.info("Checking for actual METRIC: looking for METRIC");
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 6) {
            Metric metric;
            try {
                metric = new Metric(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed METRIC Object found");
                throw new PCEPProtocolViolationException();
            }
            this.actual_metricList.add(metric);
            len += metric.getLength();
            oc = PCEPObject.getObjectClass(bytes, offset += metric.getLength());
        }
        log.info("Checking for  ACTUAL PATH: looking for RRO");
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 8) {
            try {
                this.actual_path = new ReportedRouteObject(bytes, offset);
                if (this.bandwidth != null) {
                    this.actual_bandwidth = this.bandwidth;
                    this.bandwidth = null;
                }
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed RRO Object found");
                throw new PCEPProtocolViolationException();
            }
            offset += this.actual_path.getLength();
            len += this.actual_path.getLength();
        }
        log.info("Decoding Intended attribute list");
        log.info("Checking OF");
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 21) {
            try {
                this.of = new ObjectiveFunction(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed OF Object found");
                throw new PCEPProtocolViolationException();
            }
            offset += this.of.getLength();
            len += this.of.getLength();
        }
        log.info("Checking LSPA");
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 9) {
            try {
                log.info("LSPA found");
                this.lspa = new LSPA(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed LSPA Object found");
                throw new PCEPProtocolViolationException();
            }
            offset += this.lspa.getLength();
            len += this.lspa.getLength();
        }
        try {
            oc = PCEPObject.getObjectClass(bytes, offset);
            ot = PCEPObject.getObjectType(bytes, offset);
            if (oc == 5) {
                if (ot == 1) {
                    this.bandwidth = new BandwidthRequested(bytes, offset);
                    len += this.bandwidth.getLength();
                    if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                        this.setLength(len);
                        return;
                    }
                } else if (ot == 2) {
                    this.bandwidth = new BandwidthExistingLSP(bytes, offset);
                    len += this.bandwidth.getLength();
                    if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                        this.setLength(len);
                        return;
                    }
                } else if (ot == 3) {
                    this.bandwidth = new BandwidthRequestedGeneralizedBandwidth(bytes, offset);
                    len += this.bandwidth.getLength();
                    if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                        this.setLength(len);
                        return;
                    }
                } else if (ot == 4) {
                    this.bandwidth = new BandwidthExistingLSPGeneralizedBandwidth(bytes, offset);
                    len += this.bandwidth.getLength();
                    if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                        this.setLength(len);
                        return;
                    }
                } else {
                    log.warn("Non standard bandwidth");
                    int bw_length = PCEPObject.getObjectLength(bytes, offset);
                    len += bw_length;
                    if ((offset += bw_length) >= bytes.length) {
                        this.setLength(len);
                        return;
                    }
                }
            }
        }
        catch (MalformedPCEPObjectException e) {
            log.warn("Malformed BANDWIDTH Object found");
            throw new PCEPProtocolViolationException();
        }
        if (PCEPObject.getObjectClass(bytes, offset) == 5) {
            int bw_length = PCEPObject.getObjectLength(bytes, offset);
            len += bw_length;
            if ((offset += bw_length) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 35) {
            BandwidthUtilization bu;
            try {
                bu = new BandwidthUtilization(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed BU Object found");
                throw new PCEPProtocolViolationException();
            }
            this.buList.add(bu);
            len += bu.getLength();
            if ((offset += bu.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 6) {
            Metric metric;
            try {
                metric = new Metric(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed METRIC Object found");
                throw new PCEPProtocolViolationException();
            }
            this.metricList.add(metric);
            len += metric.getLength();
            if ((offset += metric.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 10) {
            try {
                this.iro = new IncludeRouteObject(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed IRO Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.iro.getLength();
            if ((offset += this.iro.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 36) {
            try {
                this.interLayer = new InterLayer(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed interLayer Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.interLayer.getLength();
            if ((offset += this.interLayer.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 37) {
            try {
                this.switchLayer = new SwitchLayer(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed switchLayer Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.switchLayer.getLength();
            if ((offset += this.switchLayer.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 38) {
            try {
                this.reqAdapCap = new ReqAdapCap(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed reqAdapCap Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.reqAdapCap.getLength();
            if ((offset += this.reqAdapCap.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 39) {
            try {
                this.serverIndication = new ServerIndication(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed serverIndication Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.serverIndication.getLength();
            if ((offset += this.serverIndication.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        ot = PCEPObject.getObjectType(bytes, offset);
        if (oc == 130 && ot == 1) {
            try {
                this.labelSet = new BitmapLabelSet(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed Suggested Label Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.labelSet.getLength();
            if ((offset += this.labelSet.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 129) {
            try {
                this.suggestedLabel = new SuggestedLabel(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed Suggested Label Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.suggestedLabel.getLength();
            if ((offset += this.suggestedLabel.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        log.info("Checking for VENDOR-INFORMATION");
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 34) {
            log.info("VENDOR-INFORMATION FOUND");
            int vi_length = PCEPObject.getObjectLength(bytes, offset);
            len += vi_length;
            if ((offset += vi_length) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        this.setLength(len);
    }

    public void setEro(ExplicitRouteObject eRO) {
        this.ero = eRO;
    }

    public void setIro(IncludeRouteObject iRO) {
        this.iro = iRO;
    }

    public void setLspa(LSPA lSPA) {
        this.lspa = lSPA;
    }

    public void setMetricList(LinkedList<Metric> metricList) {
        this.metricList = metricList;
    }

    public void setBandwidth(Bandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    public IncludeRouteObject getIro() {
        return this.iro;
    }

    public Bandwidth getBandwidth() {
        return this.bandwidth;
    }

    public LinkedList<Metric> getMetricList() {
        return this.metricList;
    }

    public LSPA getLspa() {
        return this.lspa;
    }

    public ExplicitRouteObject getEro() {
        return this.ero;
    }

    public InterLayer getInterLayer() {
        return this.interLayer;
    }

    public void setInterLayer(InterLayer interLayer) {
        this.interLayer = interLayer;
    }

    public SwitchLayer getSwitchLayer() {
        return this.switchLayer;
    }

    public void setSwitchLayer(SwitchLayer switchLayer) {
        this.switchLayer = switchLayer;
    }

    public ReqAdapCap getReqAdapCap() {
        return this.reqAdapCap;
    }

    public void setReqAdapCap(ReqAdapCap reqAdapCap) {
        this.reqAdapCap = reqAdapCap;
    }

    public ServerIndication getServerIndication() {
        return this.serverIndication;
    }

    public void setServerIndication(ServerIndication serverIndication) {
        this.serverIndication = serverIndication;
    }

    public LabelSet getLabelSet() {
        return this.labelSet;
    }

    public void setLabelSet(LabelSet labelSet) {
        this.labelSet = labelSet;
    }

    public SuggestedLabel getSuggestedLabel() {
        return this.suggestedLabel;
    }

    public void setSuggestedLabel(SuggestedLabel suggestedLabel) {
        this.suggestedLabel = suggestedLabel;
    }

    public LinkedList<BandwidthUtilization> getBuList() {
        return this.buList;
    }

    public void setBuList(LinkedList<BandwidthUtilization> buList) {
        this.buList = buList;
    }

    public ObjectiveFunction getOf() {
        return this.of;
    }

    public void setOf(ObjectiveFunction of) {
        this.of = of;
    }

    public Bandwidth getActual_bandwidth() {
        return this.actual_bandwidth;
    }

    public void setActual_bandwidth(Bandwidth actual_bandwidth) {
        this.actual_bandwidth = actual_bandwidth;
    }

    public LinkedList<Metric> getActual_metricList() {
        return this.actual_metricList;
    }

    public void setActual_metricList(LinkedList<Metric> actual_metricList) {
        this.actual_metricList = actual_metricList;
    }

    public ReportedRouteObject getActual_path() {
        return this.actual_path;
    }

    public void setActual_path(ReportedRouteObject actual_path) {
        this.actual_path = actual_path;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.actual_bandwidth, this.actual_metricList, this.actual_path, this.bandwidth, this.buList, this.ero, this.interLayer, this.iro, this.labelSet, this.lspa, this.metricList, this.of, this.reqAdapCap, this.serverIndication, this.suggestedLabel, this.switchLayer);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return Objects.equals(this.actual_bandwidth, other.actual_bandwidth) && Objects.equals(this.actual_metricList, other.actual_metricList) && Objects.equals(this.actual_path, other.actual_path) && Objects.equals(this.bandwidth, other.bandwidth) && Objects.equals(this.buList, other.buList) && Objects.equals(this.ero, other.ero) && Objects.equals(this.interLayer, other.interLayer) && Objects.equals(this.iro, other.iro) && Objects.equals(this.labelSet, other.labelSet) && Objects.equals(this.lspa, other.lspa) && Objects.equals(this.metricList, other.metricList) && Objects.equals(this.of, other.of) && Objects.equals(this.reqAdapCap, other.reqAdapCap) && Objects.equals(this.serverIndication, other.serverIndication) && Objects.equals(this.suggestedLabel, other.suggestedLabel) && Objects.equals(this.switchLayer, other.switchLayer);
    }

    public String toString() {
        return "Path [ero=" + String.valueOf(this.ero) + ", of=" + String.valueOf(this.of) + ", lspa=" + String.valueOf(this.lspa) + ", bandwidth=" + String.valueOf(this.bandwidth) + ", buList=" + String.valueOf(this.buList) + ", metricList=" + String.valueOf(this.metricList) + ", iro=" + String.valueOf(this.iro) + ", interLayer=" + String.valueOf(this.interLayer) + ", switchLayer=" + String.valueOf(this.switchLayer) + ", reqAdapCap=" + String.valueOf(this.reqAdapCap) + ", serverIndication=" + String.valueOf(this.serverIndication) + ", labelSet=" + String.valueOf(this.labelSet) + ", suggestedLabel=" + String.valueOf(this.suggestedLabel) + ", actual_bandwidth=" + String.valueOf(this.actual_bandwidth) + ", actual_metricList=" + String.valueOf(this.actual_metricList) + ", actual_path=" + String.valueOf(this.actual_path) + "]";
    }
}

