/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.Notification;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.RequestParameters;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notify
extends PCEPConstruct {
    private LinkedList<RequestParameters> requestIdList = new LinkedList();
    private LinkedList<Notification> notificationList = new LinkedList();
    private static final Logger log = LoggerFactory.getLogger((String)"PCEPParser");

    public Notify() {
    }

    public Notify(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        if (this.notificationList.size() == 0) {
            log.warn("Notify must have at least a Nofitication object");
            throw new PCEPProtocolViolationException();
        }
        int len = 0;
        int i = 0;
        while (i < this.requestIdList.size()) {
            this.requestIdList.get(i).encode();
            len += this.requestIdList.get(i).getLength();
            ++i;
        }
        i = 0;
        while (i < this.notificationList.size()) {
            this.notificationList.get(i).encode();
            len += this.notificationList.get(i).getLength();
            ++i;
        }
        this.setLength(len);
        this.bytes = new byte[len];
        int offset = 0;
        int i2 = 0;
        while (i2 < this.requestIdList.size()) {
            System.arraycopy(this.requestIdList.get(i2).getBytes(), 0, this.bytes, offset, this.requestIdList.get(i2).getLength());
            offset += this.requestIdList.get(i2).getLength();
            ++i2;
        }
        i2 = 0;
        while (i2 < this.notificationList.size()) {
            System.arraycopy(this.notificationList.get(i2).getBytes(), 0, this.bytes, offset, this.notificationList.get(i2).getLength());
            offset += this.notificationList.get(i2).getLength();
            ++i2;
        }
    }

    private void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int len = 0;
        int max_offset = bytes.length;
        if (offset >= max_offset) {
            log.warn("Empty Notify construct!!!");
            throw new PCEPProtocolViolationException();
        }
        int oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 2) {
            RequestParameters rp;
            try {
                rp = new RequestParameters(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed RP Object found");
                throw new PCEPProtocolViolationException();
            }
            this.requestIdList.add(rp);
            len += rp.getLength();
            if ((offset += rp.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 12) {
            Notification notif;
            try {
                notif = new Notification(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed NOTIFICATION Object found");
                throw new PCEPProtocolViolationException();
            }
            this.notificationList.add(notif);
            offset += notif.getLength();
            if ((len += notif.getLength()) < this.getLength()) {
                oc = PCEPObject.getObjectClass(bytes, offset);
            }
            if (offset < max_offset) continue;
            this.setLength(len);
            return;
        }
        this.setLength(len);
    }

    public LinkedList<RequestParameters> getRequestIdList() {
        return this.requestIdList;
    }

    public void setRequestIdList(LinkedList<RequestParameters> requestIdList) {
        this.requestIdList = requestIdList;
    }

    public LinkedList<Notification> getNotificationList() {
        return this.notificationList;
    }

    public void setNotificationList(LinkedList<Notification> notificationList) {
        this.notificationList = notificationList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.notificationList == null ? 0 : this.notificationList.hashCode());
        result = 31 * result + (this.requestIdList == null ? 0 : this.requestIdList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Notify other = (Notify)obj;
        if (this.notificationList == null ? other.notificationList != null : !this.notificationList.equals(other.notificationList)) {
            return false;
        }
        return !(this.requestIdList == null ? other.requestIdList != null : !this.requestIdList.equals(other.requestIdList));
    }
}

