/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.NAI;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class NAIIPv4NodeID
extends NAI {
    private Inet4Address nodeID;

    public NAIIPv4NodeID() {
        this.setNaiType(1);
    }

    public NAIIPv4NodeID(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        this.setNaiType(1);
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int len = 4;
        int offset = 0;
        this.setLength(len);
        this.bytes = new byte[len];
        if (this.nodeID != null) {
            System.arraycopy(this.nodeID.getAddress(), 0, this.bytes, offset, 4);
        }
    }

    public void decode(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        byte[] ip = new byte[4];
        System.arraycopy(bytes, offset, ip, 0, 4);
        try {
            this.nodeID = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Inet4Address getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(Inet4Address nodeID) {
        this.nodeID = nodeID;
    }

    public String toString() {
        return "NAIIPv4NodeID [nodeID=" + String.valueOf(this.nodeID) + "]";
    }
}

