/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.NAI;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class NAIIPv4Adjacency
extends NAI {
    private Inet4Address localNodeAddress;
    private Inet4Address remoteNodeAddress;

    public NAIIPv4Adjacency() {
        this.setNaiType(3);
    }

    public NAIIPv4Adjacency(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        this.setNaiType(3);
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int len = 8;
        int offset = 0;
        this.setLength(len);
        this.bytes = new byte[len];
        if (this.localNodeAddress != null) {
            System.arraycopy(this.localNodeAddress.getAddress(), 0, this.bytes, offset, 4);
        }
        offset += 4;
        if (this.remoteNodeAddress != null) {
            System.arraycopy(this.remoteNodeAddress.getAddress(), 0, this.bytes, offset, 4);
        }
    }

    public void decode(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        byte[] ip = new byte[4];
        System.arraycopy(bytes, offset, ip, 0, 4);
        try {
            this.localNodeAddress = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        System.arraycopy(bytes, offset += 4, ip, 0, 4);
        try {
            this.remoteNodeAddress = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Inet4Address getLocalNodeAddress() {
        return this.localNodeAddress;
    }

    public void setLocalNodeAddress(Inet4Address localNodeAddress) {
        this.localNodeAddress = localNodeAddress;
    }

    public Inet4Address getRemoteNodeAddress() {
        return this.remoteNodeAddress;
    }

    public void setRemoteNodeAddress(Inet4Address remoteNodeAddress) {
        this.remoteNodeAddress = remoteNodeAddress;
    }

    public String toString() {
        return "NAIIPv4Adjacency [localNodeAddress=" + String.valueOf(this.localNodeAddress) + ", remoteNodeAddress=" + String.valueOf(this.remoteNodeAddress) + "]";
    }
}

