/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndpointRestriction;
import es.tid.pce.pcep.constructs.IPv4AddressEndPoint;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.constructs.UnnumIfEndPoint;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import java.util.LinkedList;

public class EndPointAndRestrictions
extends PCEPConstruct {
    private EndPoint endPoint;
    private LinkedList<EndpointRestriction> EndpointRestrictionList = new LinkedList();

    public EndPointAndRestrictions() {
    }

    public EndPointAndRestrictions(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int len = 0;
        this.endPoint.encode();
        len += this.endPoint.getLength();
        if (this.EndpointRestrictionList != null && this.EndpointRestrictionList.size() > 0) {
            int i = 0;
            while (i < this.EndpointRestrictionList.size()) {
                this.EndpointRestrictionList.get(i).encode();
                len += this.EndpointRestrictionList.get(i).getLength();
                ++i;
            }
        }
        this.setLength(len);
        this.bytes = new byte[len];
        int offset = 0;
        System.arraycopy(this.endPoint.getBytes(), 0, this.bytes, offset, this.endPoint.getLength());
        offset += this.endPoint.getLength();
        if (this.EndpointRestrictionList != null) {
            int i = 0;
            while (i < this.EndpointRestrictionList.size()) {
                System.arraycopy(this.EndpointRestrictionList.get(i).getBytes(), 0, this.bytes, offset, this.EndpointRestrictionList.get(i).getLength());
                offset += this.EndpointRestrictionList.get(i).getLength();
                ++i;
            }
        }
    }

    public void decode(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        try {
            int len = 0;
            int tlvtype = PCEPTLV.getType(bytes, offset);
            int tlvlength = PCEPTLV.getTotalTLVLength(bytes, offset);
            if (tlvtype == 39) {
                this.endPoint = new IPv4AddressEndPoint(bytes, offset);
            } else if (tlvtype == 41) {
                this.endPoint = new UnnumIfEndPoint(bytes, offset);
            }
            offset += this.endPoint.getLength();
            len += this.endPoint.getLength();
            while (offset < bytes.length && PCEPTLV.getType(bytes, offset) == 2000) {
                EndpointRestriction EndpointRestriction2 = new EndpointRestriction(bytes, offset);
                this.EndpointRestrictionList.add(EndpointRestriction2);
                offset += EndpointRestriction2.getLength();
                len += EndpointRestriction2.getLength();
            }
            this.setLength(len);
        }
        catch (PCEPProtocolViolationException e) {
            throw new MalformedPCEPObjectException();
        }
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(EndPoint EndPoint2) {
        this.endPoint = EndPoint2;
    }

    public LinkedList<EndpointRestriction> getEndPointRestrictionList() {
        return this.EndpointRestrictionList;
    }

    public void setEndPointRestrictionList(LinkedList<EndpointRestriction> EndPointRestrictionList) {
        this.EndpointRestrictionList = EndPointRestrictionList;
    }

    public LinkedList<EndpointRestriction> getEndpointRestrictionList() {
        return this.EndpointRestrictionList;
    }

    public void setEndpointRestrictionList(LinkedList<EndpointRestriction> endpointRestrictionList) {
        this.EndpointRestrictionList = endpointRestrictionList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.EndpointRestrictionList == null ? 0 : this.EndpointRestrictionList.hashCode());
        result = 31 * result + (this.endPoint == null ? 0 : this.endPoint.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndPointAndRestrictions other = (EndPointAndRestrictions)obj;
        if (this.EndpointRestrictionList == null ? other.EndpointRestrictionList != null : !this.EndpointRestrictionList.equals(other.EndpointRestrictionList)) {
            return false;
        }
        return !(this.endPoint == null ? other.endPoint != null : !this.endPoint.equals(other.endPoint));
    }
}

