/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import java.net.Inet4Address;
import java.util.Arrays;
import java.util.LinkedList;

public abstract class LabelSetField {
    protected int action;
    protected int numLabels;
    protected int length;
    protected LinkedList<Inet4Address> labels;
    protected byte[] bytes;

    public void encodeHeader() {
        int offset = 0;
        this.bytes[offset] = (byte)(this.action << 4 | this.numLabels >> 8 & 0xF);
        this.bytes[offset + 1] = (byte)(this.numLabels & 0xFF);
        this.bytes[offset + 2] = (byte)(this.length >> 8 & 0xFF);
        this.bytes[offset + 3] = (byte)(this.length & 0xFF);
    }

    public void decodeHeader() {
        int offset = 0;
        this.action = (this.bytes[offset] & 0xF0) >> 4;
        this.numLabels = (this.bytes[offset] & 0xF) << 8 | this.bytes[offset + 1] & 0xFF;
    }

    public abstract void encode();

    public abstract void decode() throws MalformedOSPFSubTLVException;

    public Inet4Address getBaseLabel() {
        return this.labels.getFirst();
    }

    public Inet4Address getLastLabel() {
        return this.labels.getLast();
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public int getNumLabels() {
        return this.numLabels;
    }

    public void setNumLabels(int numLabels) {
        this.numLabels = numLabels;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public LinkedList<Inet4Address> getLabels() {
        return this.labels;
    }

    public void setLabels(LinkedList<Inet4Address> labels) {
        this.labels = labels;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String toString() {
        Object ret = "";
        ret = (String)ret + "Action: " + String.valueOf(this.action) + "\t";
        ret = (String)ret + "Number of Labels: " + String.valueOf(this.numLabels) + "\r\n";
        return ret;
    }

    public abstract LabelSetField duplicate();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.action;
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
        result = 31 * result + this.length;
        result = 31 * result + this.numLabels;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelSetField other = (LabelSetField)obj;
        if (this.action != other.action) {
            return false;
        }
        if (!Arrays.equals(this.bytes, other.bytes)) {
            return false;
        }
        if (this.labels == null ? other.labels != null : !this.labels.equals(other.labels)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return this.numLabels == other.numLabels;
    }
}

