/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;

public class UnreservedBandwidth
extends OSPFSubTLV {
    public float[] unreservedBandwidth;

    public UnreservedBandwidth() {
        this.setTLVType(8);
        this.unreservedBandwidth = new float[8];
    }

    public UnreservedBandwidth(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.unreservedBandwidth = new float[8];
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(32);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        int i = 0;
        while (i < 8) {
            int bwi = Float.floatToIntBits(this.unreservedBandwidth[i]);
            this.tlv_bytes[offset] = (byte)(bwi >>> 24);
            this.tlv_bytes[offset + 1] = (byte)(bwi >> 16 & 0xFF);
            this.tlv_bytes[offset + 2] = (byte)(bwi >> 8 & 0xFF);
            this.tlv_bytes[offset + 3] = (byte)(bwi & 0xFF);
            offset += 4;
            ++i;
        }
    }

    @Override
    protected void decode() throws MalformedOSPFSubTLVException {
        if (this.getTLVValueLength() != 32) {
            throw new MalformedOSPFSubTLVException();
        }
        int bwi = 0;
        int offset = 4;
        int i = 0;
        while (i < 8) {
            bwi = 0;
            int k = 0;
            while (k < 4) {
                bwi = bwi << 8 | this.tlv_bytes[offset + k] & 0xFF;
                ++k;
            }
            this.unreservedBandwidth[i] = Float.intBitsToFloat(bwi);
            offset += 4;
            ++i;
        }
    }

    public String toString() {
        Object ret = "";
        int i = 0;
        while (i < 7) {
            ret = (String)ret + "unreservedBandwidth[" + i + "]: " + Float.toString(this.unreservedBandwidth[i]) + "\r\n";
            ++i;
        }
        ret = (String)ret + "unreservedBandwidth[7]: " + Float.toString(this.unreservedBandwidth[7]);
        return ret;
    }

    public String toStringShort() {
        String ret = "unrBw[0]: " + this.unreservedBandwidth[0];
        return ret;
    }

    public float[] getUnreservedBandwidth() {
        return this.unreservedBandwidth;
    }

    public void setUnreservedBandwidth(float[] unreservedBandwidth) {
        this.unreservedBandwidth = unreservedBandwidth;
    }
}

