/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class SharedRiskLinkGroup
extends OSPFSubTLV {
    private LinkedList<Inet4Address> sharedRiskLinkGroupValues;

    public SharedRiskLinkGroup() {
        this.setTLVType(16);
        this.sharedRiskLinkGroupValues = new LinkedList();
    }

    public SharedRiskLinkGroup(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.sharedRiskLinkGroupValues = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(this.sharedRiskLinkGroupValues.size() * 4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        int i = 0;
        while (i < this.sharedRiskLinkGroupValues.size()) {
            System.arraycopy(this.sharedRiskLinkGroupValues.get(i).getAddress(), 0, this.tlv_bytes, offset, 4);
            offset += 4;
            ++i;
        }
    }

    @Override
    public void decode() throws MalformedOSPFSubTLVException {
        int numIPAddresses = this.getTLVValueLength() / 4;
        byte[] ip = new byte[4];
        int offset = 4;
        int i = 0;
        while (i < numIPAddresses) {
            System.arraycopy(this.tlv_bytes, offset, ip, 0, 4);
            try {
                this.sharedRiskLinkGroupValues.add((Inet4Address)Inet4Address.getByAddress(ip));
                offset += 4;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                throw new MalformedOSPFSubTLVException();
            }
            ++i;
        }
    }

    public LinkedList<Inet4Address> getSharedRiskLinkGroupValues() {
        return this.sharedRiskLinkGroupValues;
    }

    public void setSharedRiskLinkGroupValues(LinkedList<Inet4Address> sharedRiskLinkGroupValues) {
        this.sharedRiskLinkGroupValues = sharedRiskLinkGroupValues;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sharedRiskLinkGroupValues == null ? 0 : this.sharedRiskLinkGroupValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SharedRiskLinkGroup other = (SharedRiskLinkGroup)obj;
        return !(this.sharedRiskLinkGroupValues == null ? other.sharedRiskLinkGroupValues != null : !this.sharedRiskLinkGroupValues.equals(other.sharedRiskLinkGroupValues));
    }
}

