/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class RemoteInterfaceIPAddress
extends OSPFSubTLV {
    private LinkedList<Inet4Address> remoteInterfaceIPAddressList;

    public RemoteInterfaceIPAddress() {
        this.setTLVType(4);
        this.remoteInterfaceIPAddressList = new LinkedList();
    }

    public RemoteInterfaceIPAddress(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.remoteInterfaceIPAddressList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(this.remoteInterfaceIPAddressList.size() * 4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        int i = 0;
        while (i < this.remoteInterfaceIPAddressList.size()) {
            System.arraycopy(this.remoteInterfaceIPAddressList.get(i).getAddress(), 0, this.tlv_bytes, offset, 4);
            offset += 4;
            ++i;
        }
    }

    @Override
    protected void decode() throws MalformedOSPFSubTLVException {
        int numIPAddresses = this.getTLVValueLength() / 4;
        byte[] ip = new byte[4];
        int offset = 4;
        int i = 0;
        while (i < numIPAddresses) {
            System.arraycopy(this.tlv_bytes, offset, ip, 0, 4);
            try {
                this.remoteInterfaceIPAddressList.add((Inet4Address)Inet4Address.getByAddress(ip));
                offset += 4;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                throw new MalformedOSPFSubTLVException();
            }
            ++i;
        }
    }

    public void addRemoteInterfaceIPAddress(Inet4Address address) {
        this.remoteInterfaceIPAddressList.add(address);
    }

    public Inet4Address getRemoteInterfaceIPAddress(int i) {
        return this.remoteInterfaceIPAddressList.get(i);
    }

    public LinkedList<Inet4Address> getRemoteInterfaceIPAddressList() {
        return this.remoteInterfaceIPAddressList;
    }

    public void setRemoteInterfaceIPAddressList(LinkedList<Inet4Address> localInterfaceIPAddressList) {
        this.remoteInterfaceIPAddressList = localInterfaceIPAddressList;
    }

    public String toString() {
        Object ret = "";
        int i = 0;
        while (i < this.remoteInterfaceIPAddressList.size()) {
            ret = "remoteInterfaceIPAddress[" + i + "]: " + this.remoteInterfaceIPAddressList.get(i).toString();
            ++i;
        }
        return ret;
    }
}

