/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;

public class MaximumReservableBandwidth
extends OSPFSubTLV {
    public float maximumReservableBandwidth;

    public MaximumReservableBandwidth() {
        this.setTLVType(7);
    }

    public MaximumReservableBandwidth(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int bwi = Float.floatToIntBits(this.maximumReservableBandwidth);
        this.tlv_bytes[4] = (byte)(bwi >>> 24);
        this.tlv_bytes[5] = (byte)(bwi >> 16 & 0xFF);
        this.tlv_bytes[6] = (byte)(bwi >> 8 & 0xFF);
        this.tlv_bytes[7] = (byte)(bwi & 0xFF);
    }

    @Override
    protected void decode() throws MalformedOSPFSubTLVException {
        if (this.getTLVValueLength() != 4) {
            throw new MalformedOSPFSubTLVException();
        }
        int bwi = 0;
        int k = 0;
        while (k < 4) {
            bwi = bwi << 8 | this.tlv_bytes[k + 4] & 0xFF;
            ++k;
        }
        this.maximumReservableBandwidth = Float.intBitsToFloat(bwi);
    }

    public void setMaximumReservableBandwidth(float maximumReservableBandwidth) {
        this.maximumReservableBandwidth = maximumReservableBandwidth;
    }

    public float getMaximumReservableBandwidth() {
        return this.maximumReservableBandwidth;
    }

    public String toString() {
        return "maximumReservableBandwidth: " + Float.toString(this.maximumReservableBandwidth);
    }
}

