/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.LabelTypeTLV;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;

public class MF_OTPAttribSubTLV
extends OSPFSubTLV {
    private int MatrixID;
    private int RstType;
    private int Swcap;
    private int Encoding;
    private int TxSubTrnsp;
    private int RxSubTrnsp;
    private int AvailTxSTrnsp;
    private int AvailRxTrnsp;
    private int CFG;
    private int SWG;
    private int Reserved;
    private int MinWidth;
    private int MaxWidth;
    private LabelTypeTLV txAggregatedOpticalSpec;
    private LabelTypeTLV rxAggregatedOpticalSpec;

    public MF_OTPAttribSubTLV() {
        this.setTLVType(26);
    }

    public MF_OTPAttribSubTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int valueLength = 16;
        log.info("******************* Codificando MF OTP *****************");
        if (this.txAggregatedOpticalSpec != null) {
            this.txAggregatedOpticalSpec.encode();
            valueLength += this.txAggregatedOpticalSpec.getTotalTLVLength();
        }
        if (this.rxAggregatedOpticalSpec != null) {
            this.rxAggregatedOpticalSpec.encode();
            valueLength += this.rxAggregatedOpticalSpec.getTotalTLVLength();
        }
        this.setTLVValueLength(valueLength);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.MatrixID & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.RstType & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.Swcap & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.Encoding & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.TxSubTrnsp & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.RxSubTrnsp & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.AvailTxSTrnsp & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.AvailRxTrnsp & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.CFG & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.SWG & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.Reserved >> 8 & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.Reserved & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.MinWidth >> 8 & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.MinWidth & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.MaxWidth >> 8 & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.MaxWidth & 0xFF);
        ++offset;
        if (this.txAggregatedOpticalSpec != null) {
            System.arraycopy(this.txAggregatedOpticalSpec.getTlv_bytes(), 0, this.tlv_bytes, offset, this.txAggregatedOpticalSpec.getTotalTLVLength());
        }
        offset += this.txAggregatedOpticalSpec.getTotalTLVLength();
        if (this.rxAggregatedOpticalSpec != null) {
            System.arraycopy(this.rxAggregatedOpticalSpec.getTlv_bytes(), 0, this.tlv_bytes, offset, this.rxAggregatedOpticalSpec.getTotalTLVLength());
        }
        log.info("***************** FIN Codificando MF OTP ***************");
    }

    @Override
    protected void decode() {
        int offset = 4;
        log.info("******************* Decodificando MF OTP *****************");
        this.MatrixID = this.tlv_bytes[offset] & 0xFF;
        log.info("Valor de MatrixID del MF_OTP: " + this.MatrixID + ".");
        this.RstType = this.tlv_bytes[++offset] & 0xFF;
        log.info("Valor de RstType del MF_OTP: " + this.RstType + ".");
        this.Swcap = this.tlv_bytes[++offset] & 0xFF;
        log.info("Valor de Swcap del MF_OTP: " + this.Swcap + ".");
        this.Encoding = this.tlv_bytes[++offset] & 0xFF;
        log.info("Valor de Encoding del MF_OTP: " + this.Encoding + ".");
        this.TxSubTrnsp = this.tlv_bytes[++offset] & 0xFF;
        log.info("Valor de TxSubTrnsp del MF_OTP: " + this.TxSubTrnsp + ".");
        this.RxSubTrnsp = this.tlv_bytes[++offset] & 0xFF;
        log.info("Valor de RxSubTrnsp del MF_OTP: " + this.RxSubTrnsp + ".");
        this.AvailTxSTrnsp = this.tlv_bytes[++offset] & 0xFF;
        log.info("Valor de AvailTxSTrnsp del MF_OTP: " + this.AvailTxSTrnsp + ".");
        this.AvailRxTrnsp = this.tlv_bytes[++offset] & 0xFF;
        log.info("Valor de AvailRxTrnsp del MF_OTP: " + this.AvailRxTrnsp + ".");
        this.CFG = this.tlv_bytes[++offset] & 0xFF;
        log.info("Valor de CFG del MF_OTP: " + this.CFG + ".");
        this.SWG = this.tlv_bytes[++offset] & 0xFF;
        log.info("Valor de SWG del MF_OTP: " + this.SWG + ".");
        this.Reserved = (this.tlv_bytes[++offset] & 0xFF) << 8 | this.tlv_bytes[offset + 1] & 0xFF;
        log.info("Valor de Reserved del MF_OTP: " + this.Reserved + ".");
        offset = offset + 1 + 1;
        this.MinWidth = (this.tlv_bytes[offset] & 0xFF) << 8 | this.tlv_bytes[offset + 1] & 0xFF;
        log.info("Valor de MinWidth del MF_OTP: " + this.MinWidth + ".");
        offset = offset + 1 + 1;
        this.MaxWidth = (this.tlv_bytes[offset] & 0xFF) << 8 | this.tlv_bytes[offset + 1] & 0xFF;
        log.info("Valor de MaxWidth del MF_OTP: " + this.MaxWidth + ".");
        offset = offset + 1 + 1;
        log.info("Lenght: " + this.getTotalTLVLength());
        log.info("offset: " + offset);
        this.txAggregatedOpticalSpec = new LabelTypeTLV(this.tlv_bytes, offset);
        this.rxAggregatedOpticalSpec = new LabelTypeTLV(this.tlv_bytes, offset += this.txAggregatedOpticalSpec.getTotalTLVLength());
        log.info("***************** FIN Decodificando MF OTP ***************");
    }

    public LabelTypeTLV getTxAggregatedOpticalSpec() {
        return this.txAggregatedOpticalSpec;
    }

    public void setTxAggregatedOpticalSpec(LabelTypeTLV txAggregatedOpticalSpec) {
        this.txAggregatedOpticalSpec = txAggregatedOpticalSpec;
    }

    public LabelTypeTLV getRxAggregatedOpticalSpec() {
        return this.rxAggregatedOpticalSpec;
    }

    public void setRxAggregatedOpticalSpec(LabelTypeTLV rxAggregatedOpticalSpec) {
        this.rxAggregatedOpticalSpec = rxAggregatedOpticalSpec;
    }

    public String toString() {
        String str = "<MFOTP\n MatrixID: " + this.MatrixID + "| RstType:  " + this.RstType + "| Swcap: " + this.Swcap + "\n Encoding:   " + this.Encoding + "| TxST:    " + this.TxSubTrnsp + "| RxST:  " + this.RxSubTrnsp + "\n AvTxST:    " + this.AvailTxSTrnsp + "| AvRxST:  " + this.AvailRxTrnsp + "| CFG:   " + this.CFG + "\n SWG:        " + this.SWG + "| Reserved: " + this.Reserved + "| MinW:  " + this.MinWidth + "\n MaxW:       " + this.MaxWidth + "|\n -------------------\n TxAggOptSpec: " + this.txAggregatedOpticalSpec.toString() + "\n -------------------\n RxAggOptSpec: " + this.rxAggregatedOpticalSpec.toString();
        str = str + "\n>";
        return str;
    }

    public int getMatrixID() {
        return this.MatrixID;
    }

    public void setMatrixID(int matrixID) {
        this.MatrixID = matrixID;
    }

    public int getRstType() {
        return this.RstType;
    }

    public void setRstType(int rstType) {
        this.RstType = rstType;
    }

    public int getSwcap() {
        return this.Swcap;
    }

    public void setSwcap(int swcap) {
        this.Swcap = swcap;
    }

    public int getEncoding() {
        return this.Encoding;
    }

    public void setEncoding(int encoding) {
        this.Encoding = encoding;
    }

    public int getTxSubTrnsp() {
        return this.TxSubTrnsp;
    }

    public void setTxSubTrnsp(int txSubTrnsp) {
        this.TxSubTrnsp = txSubTrnsp;
    }

    public int getRxSubTrnsp() {
        return this.RxSubTrnsp;
    }

    public void setRxSubTrnsp(int rxSubTrnsp) {
        this.RxSubTrnsp = rxSubTrnsp;
    }

    public int getAvailTxSTrnsp() {
        return this.AvailTxSTrnsp;
    }

    public void setAvailTxSTrnsp(int availTxSTrnsp) {
        this.AvailTxSTrnsp = availTxSTrnsp;
    }

    public int getAvailRxTrnsp() {
        return this.AvailRxTrnsp;
    }

    public void setAvailRxTrnsp(int availRxTrnsp) {
        this.AvailRxTrnsp = availRxTrnsp;
    }

    public int getCFG() {
        return this.CFG;
    }

    public void setCFG(int cFG) {
        this.CFG = cFG;
    }

    public int getSWG() {
        return this.SWG;
    }

    public void setSWG(int sWG) {
        this.SWG = sWG;
    }

    public int getReserved() {
        return this.Reserved;
    }

    public void setReserved(int reserved) {
        this.Reserved = reserved;
    }

    public int getMinWidth() {
        return this.MinWidth;
    }

    public void setMinWidth(int minWidth) {
        this.MinWidth = minWidth;
    }

    public int getMaxWidth() {
        return this.MaxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.MaxWidth = maxWidth;
    }

    public MF_OTPAttribSubTLV duplicate() {
        MF_OTPAttribSubTLV mm = new MF_OTPAttribSubTLV();
        mm.AvailRxTrnsp = this.AvailRxTrnsp;
        mm.AvailTxSTrnsp = this.AvailTxSTrnsp;
        mm.CFG = this.CFG;
        mm.Encoding = this.Encoding;
        mm.MatrixID = this.MatrixID;
        mm.MaxWidth = this.MaxWidth;
        mm.MinWidth = this.MinWidth;
        mm.Reserved = this.Reserved;
        mm.RstType = this.RstType;
        mm.SWG = this.SWG;
        mm.Swcap = this.Swcap;
        mm.TxSubTrnsp = this.TxSubTrnsp;
        mm.RxSubTrnsp = this.RxSubTrnsp;
        mm.txAggregatedOpticalSpec = this.txAggregatedOpticalSpec.duplicate();
        mm.rxAggregatedOpticalSpec = this.rxAggregatedOpticalSpec.duplicate();
        return mm;
    }
}

