/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class LocalInterfaceIPAddress
extends OSPFSubTLV {
    private LinkedList<Inet4Address> localInterfaceIPAddressList;

    public LocalInterfaceIPAddress() {
        this.setTLVType(3);
        this.localInterfaceIPAddressList = new LinkedList();
    }

    public LocalInterfaceIPAddress(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.localInterfaceIPAddressList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(this.localInterfaceIPAddressList.size() * 4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        int i = 0;
        while (i < this.localInterfaceIPAddressList.size()) {
            System.arraycopy(this.localInterfaceIPAddressList.get(i).getAddress(), 0, this.tlv_bytes, offset, 4);
            offset += 4;
            ++i;
        }
    }

    @Override
    protected void decode() throws MalformedOSPFSubTLVException {
        int numIPAddresses = this.getTLVValueLength() / 4;
        byte[] ip = new byte[4];
        int offset = 4;
        int i = 0;
        while (i < numIPAddresses) {
            System.arraycopy(this.tlv_bytes, offset, ip, 0, 4);
            try {
                this.localInterfaceIPAddressList.add((Inet4Address)Inet4Address.getByAddress(ip));
                offset += 4;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                throw new MalformedOSPFSubTLVException();
            }
            ++i;
        }
    }

    public void addLocalInterfaceIPAddress(Inet4Address address) {
        this.localInterfaceIPAddressList.add(address);
    }

    public Inet4Address getLocalInterfaceIPAddress(int i) {
        return this.localInterfaceIPAddressList.get(i);
    }

    public LinkedList<Inet4Address> getLocalInterfaceIPAddressList() {
        return this.localInterfaceIPAddressList;
    }

    public void setLocalInterfaceIPAddressList(LinkedList<Inet4Address> localInterfaceIPAddressList) {
        this.localInterfaceIPAddressList = localInterfaceIPAddressList;
    }

    public String toString() {
        Object ret = "";
        int i = 0;
        while (i < this.localInterfaceIPAddressList.size()) {
            ret = "localInterfaceIPAddress[" + i + "]: " + this.localInterfaceIPAddressList.get(i).toString();
            ++i;
        }
        return ret;
    }
}

