/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;

public class LinkLocalRemoteIdentifiers
extends OSPFSubTLV {
    private long linkLocalIdentifier;
    private long linkRemoteIdentifier;

    public LinkLocalRemoteIdentifiers() {
        this.setTLVType(11);
    }

    public LinkLocalRemoteIdentifiers(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(8);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.linkLocalIdentifier >> 24 & 0xFFL);
        this.tlv_bytes[offset + 1] = (byte)(this.linkLocalIdentifier >> 16 & 0xFFL);
        this.tlv_bytes[offset + 2] = (byte)(this.linkLocalIdentifier >> 8 & 0xFFL);
        this.tlv_bytes[offset + 3] = (byte)(this.linkLocalIdentifier & 0xFFL);
        this.tlv_bytes[offset += 4] = (byte)(this.linkRemoteIdentifier >> 24 & 0xFFL);
        this.tlv_bytes[offset + 1] = (byte)(this.linkRemoteIdentifier >> 16 & 0xFFL);
        this.tlv_bytes[offset + 2] = (byte)(this.linkRemoteIdentifier >> 8 & 0xFFL);
        this.tlv_bytes[offset + 3] = (byte)(this.linkRemoteIdentifier & 0xFFL);
    }

    @Override
    protected void decode() throws MalformedOSPFSubTLVException {
        if (this.getTLVValueLength() != 8) {
            throw new MalformedOSPFSubTLVException();
        }
        int offset = 4;
        this.linkLocalIdentifier = (long)(this.tlv_bytes[offset] << 24) & 0xFFFFFFFFFF000000L | (long)(this.tlv_bytes[offset + 1] << 16 & 0xFF0000) | (long)(this.tlv_bytes[offset + 2] << 8 & 0xFF00) | (long)(this.tlv_bytes[offset + 3] & 0xFF);
        offset = 8;
        this.linkRemoteIdentifier = (long)(this.tlv_bytes[offset] << 24) & 0xFFFFFFFFFF000000L | (long)(this.tlv_bytes[offset + 1] << 16 & 0xFF0000) | (long)(this.tlv_bytes[offset + 2] << 8 & 0xFF00) | (long)(this.tlv_bytes[offset + 3] & 0xFF);
    }

    public long getLinkLocalIdentifier() {
        return this.linkLocalIdentifier;
    }

    public void setLinkLocalIdentifier(long linkLocalIdentifier) {
        this.linkLocalIdentifier = linkLocalIdentifier;
    }

    public long getLinkRemoteIdentifier() {
        return this.linkRemoteIdentifier;
    }

    public void setLinkRemoteIdentifier(long linkRemoteIdentifier) {
        this.linkRemoteIdentifier = linkRemoteIdentifier;
    }

    @Override
    public boolean equals(Object obj) {
        return Long.valueOf(((LinkLocalRemoteIdentifiers)obj).getLinkLocalIdentifier()).equals(this.linkLocalIdentifier) && Long.valueOf(((LinkLocalRemoteIdentifiers)obj).getLinkRemoteIdentifier()).equals(this.linkRemoteIdentifier);
    }

    public String toString() {
        String ret = "linkLocalIdentifier: " + this.linkLocalIdentifier + " linkRemoteIdentifier: " + this.linkRemoteIdentifier;
        return ret;
    }
}

