/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;

public class AdministrativeGroup
extends OSPFSubTLV {
    private int administrativeGroup;

    public AdministrativeGroup() {
        this.setTLVType(9);
        this.administrativeGroup = 0;
    }

    public AdministrativeGroup(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() throws MalformedOSPFSubTLVException {
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.administrativeGroup >> 24 & 0xFF);
        this.tlv_bytes[offset + 1] = (byte)(this.administrativeGroup >> 16 & 0xFF);
        this.tlv_bytes[offset + 2] = (byte)(this.administrativeGroup >> 8 & 0xFF);
        this.tlv_bytes[offset + 3] = (byte)(this.administrativeGroup & 0xFF);
    }

    @Override
    protected void decode() throws MalformedOSPFSubTLVException {
        if (this.getTLVValueLength() != 4) {
            throw new MalformedOSPFSubTLVException();
        }
        int offset = 4;
        this.administrativeGroup = (this.tlv_bytes[offset] & 0xFF) << 24 | (this.tlv_bytes[offset + 1] & 0xFF) << 16 | (this.tlv_bytes[offset + 2] & 0xFF) << 8 | this.tlv_bytes[offset + 3] & 0xFF;
    }

    public String toString() {
        return "AdministrativeGroup: " + Integer.toBinaryString(this.administrativeGroup);
    }

    public int getAdministrativeGroup() {
        return this.administrativeGroup;
    }

    public void setAdministrativeGroup(int administrativeGroup) {
        this.administrativeGroup = administrativeGroup;
    }

    public boolean isGroup(int groupNumber) {
        return this.administrativeGroup >>> groupNumber == 1;
    }

    public void setGroup(int groupNumber) {
        this.administrativeGroup |= 1 << groupNumber;
    }
}

