/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv;

import es.tid.ospf.ospfv2.lsa.tlv.MalformedOSPFTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.OSPFTLV;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.AdministrativeGroup;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.AvailableLabels;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.IPv4RemoteASBRID;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.LinkID;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.LinkLocalRemoteIdentifiers;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.LinkProtectionType;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.LinkType;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.LocalInterfaceIPAddress;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MaximumBandwidth;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MaximumReservableBandwidth;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.RemoteASNumber;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.RemoteInterfaceIPAddress;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.SharedRiskLinkGroup;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.TrafficEngineeringMetric;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.UnreservedBandwidth;

public class LinkTLV
extends OSPFTLV {
    private LinkType linkType;
    private LinkID linkID;
    private LocalInterfaceIPAddress localInterfaceIPAddress;
    private RemoteInterfaceIPAddress remoteInterfaceIPAddress;
    private TrafficEngineeringMetric trafficEngineeringMetric;
    private MaximumBandwidth maximumBandwidth;
    private MaximumReservableBandwidth maximumReservableBandwidth;
    private UnreservedBandwidth unreservedBandwidth;
    private AdministrativeGroup administrativeGroup;
    private LinkLocalRemoteIdentifiers linkLocalRemoteIdentifiers;
    private LinkProtectionType linkProtectionType;
    private SharedRiskLinkGroup sharedRiskLinkGroup;
    private RemoteASNumber remoteASNumber;
    private IPv4RemoteASBRID iPv4RemoteASBRID;
    private AvailableLabels availableLabels;

    public LinkTLV() {
        this.setTLVType(2);
    }

    public LinkTLV(byte[] bytes, int offset) throws MalformedOSPFTLVException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int valueLength = 0;
        if (this.linkType != null) {
            this.linkType.encode();
            valueLength += this.linkType.getTotalTLVLength();
        }
        if (this.linkID != null) {
            this.linkID.encode();
            valueLength += this.linkID.getTotalTLVLength();
        }
        if (this.localInterfaceIPAddress != null) {
            this.localInterfaceIPAddress.encode();
            valueLength += this.localInterfaceIPAddress.getTotalTLVLength();
        }
        if (this.remoteInterfaceIPAddress != null) {
            this.remoteInterfaceIPAddress.encode();
            valueLength += this.remoteInterfaceIPAddress.getTotalTLVLength();
        }
        if (this.maximumBandwidth != null) {
            this.maximumBandwidth.encode();
            valueLength += this.maximumBandwidth.getTotalTLVLength();
        }
        if (this.maximumReservableBandwidth != null) {
            this.maximumReservableBandwidth.encode();
            valueLength += this.maximumReservableBandwidth.getTotalTLVLength();
        }
        if (this.unreservedBandwidth != null) {
            this.unreservedBandwidth.encode();
            valueLength += this.unreservedBandwidth.getTotalTLVLength();
        }
        if (this.administrativeGroup != null) {
            try {
                this.administrativeGroup.encode();
            }
            catch (MalformedOSPFSubTLVException e) {
                e.printStackTrace();
            }
            valueLength += this.administrativeGroup.getTotalTLVLength();
        }
        if (this.linkLocalRemoteIdentifiers != null) {
            this.linkLocalRemoteIdentifiers.encode();
            valueLength += this.linkLocalRemoteIdentifiers.getTotalTLVLength();
        }
        if (this.remoteASNumber != null) {
            this.remoteASNumber.encode();
            valueLength += this.remoteASNumber.getTotalTLVLength();
        }
        if (this.iPv4RemoteASBRID != null) {
            this.iPv4RemoteASBRID.encode();
            valueLength += this.iPv4RemoteASBRID.getTotalTLVLength();
        }
        if (this.availableLabels != null) {
            try {
                this.availableLabels.encode();
            }
            catch (MalformedOSPFSubTLVException e) {
                e.printStackTrace();
            }
            valueLength += this.availableLabels.getTotalTLVLength();
        }
        this.setTLVValueLength(valueLength);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        if (this.linkType != null) {
            System.arraycopy(this.linkType.getTlv_bytes(), 0, this.tlv_bytes, offset, this.linkType.getTotalTLVLength());
            offset += this.linkType.getTotalTLVLength();
        }
        if (this.linkID != null) {
            System.arraycopy(this.linkID.getTlv_bytes(), 0, this.tlv_bytes, offset, this.linkID.getTotalTLVLength());
            offset += this.linkID.getTotalTLVLength();
        }
        if (this.localInterfaceIPAddress != null) {
            System.arraycopy(this.localInterfaceIPAddress.getTlv_bytes(), 0, this.tlv_bytes, offset, this.localInterfaceIPAddress.getTotalTLVLength());
            offset += this.localInterfaceIPAddress.getTotalTLVLength();
        }
        if (this.remoteInterfaceIPAddress != null) {
            System.arraycopy(this.remoteInterfaceIPAddress.getTlv_bytes(), 0, this.tlv_bytes, offset, this.remoteInterfaceIPAddress.getTotalTLVLength());
            offset += this.remoteInterfaceIPAddress.getTotalTLVLength();
        }
        if (this.maximumBandwidth != null) {
            System.arraycopy(this.maximumBandwidth.getTlv_bytes(), 0, this.tlv_bytes, offset, this.maximumBandwidth.getTotalTLVLength());
            offset += this.maximumBandwidth.getTotalTLVLength();
        }
        if (this.maximumReservableBandwidth != null) {
            System.arraycopy(this.maximumReservableBandwidth.getTlv_bytes(), 0, this.tlv_bytes, offset, this.maximumReservableBandwidth.getTotalTLVLength());
            offset += this.maximumReservableBandwidth.getTotalTLVLength();
        }
        if (this.unreservedBandwidth != null) {
            System.arraycopy(this.unreservedBandwidth.getTlv_bytes(), 0, this.tlv_bytes, offset, this.unreservedBandwidth.getTotalTLVLength());
            offset += this.unreservedBandwidth.getTotalTLVLength();
        }
        if (this.administrativeGroup != null) {
            System.arraycopy(this.administrativeGroup.getTlv_bytes(), 0, this.tlv_bytes, offset, this.administrativeGroup.getTotalTLVLength());
            offset += this.administrativeGroup.getTotalTLVLength();
        }
        if (this.linkLocalRemoteIdentifiers != null) {
            System.arraycopy(this.linkLocalRemoteIdentifiers.getTlv_bytes(), 0, this.tlv_bytes, offset, this.linkLocalRemoteIdentifiers.getTotalTLVLength());
            offset += this.linkLocalRemoteIdentifiers.getTotalTLVLength();
        }
        if (this.remoteASNumber != null) {
            System.arraycopy(this.remoteASNumber.getTlv_bytes(), 0, this.tlv_bytes, offset, this.remoteASNumber.getTotalTLVLength());
            offset += this.remoteASNumber.getTotalTLVLength();
        }
        if (this.iPv4RemoteASBRID != null) {
            System.arraycopy(this.iPv4RemoteASBRID.getTlv_bytes(), 0, this.tlv_bytes, offset, this.iPv4RemoteASBRID.getTotalTLVLength());
            offset += this.iPv4RemoteASBRID.getTotalTLVLength();
        }
        if (this.availableLabels != null) {
            System.arraycopy(this.availableLabels.getTlv_bytes(), 0, this.tlv_bytes, offset, this.availableLabels.getTotalTLVLength());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void decode() throws MalformedOSPFTLVException {
        fin = false;
        offset = 4;
        if (this.getTLVValueLength() != 0) ** GOTO lbl63
        throw new MalformedOSPFTLVException();
lbl-1000:
        // 1 sources

        {
            subTLVType = OSPFSubTLV.getType(this.getTlv_bytes(), offset);
            subTLVLength = OSPFSubTLV.getTotalTLVLength(this.getTlv_bytes(), offset);
            try {
                switch (subTLVType) {
                    case 2: {
                        this.linkID = new LinkID(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 1: {
                        this.linkType = new LinkType(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 3: {
                        this.localInterfaceIPAddress = new LocalInterfaceIPAddress(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 4: {
                        this.remoteInterfaceIPAddress = new RemoteInterfaceIPAddress(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 5: {
                        this.trafficEngineeringMetric = new TrafficEngineeringMetric(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 6: {
                        this.maximumBandwidth = new MaximumBandwidth(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 7: {
                        this.maximumReservableBandwidth = new MaximumReservableBandwidth(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 8: {
                        this.unreservedBandwidth = new UnreservedBandwidth(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 9: {
                        this.administrativeGroup = new AdministrativeGroup(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 11: {
                        this.linkLocalRemoteIdentifiers = new LinkLocalRemoteIdentifiers(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 14: {
                        this.linkProtectionType = new LinkProtectionType(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 16: {
                        this.sharedRiskLinkGroup = new SharedRiskLinkGroup(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 21: {
                        this.remoteASNumber = new RemoteASNumber(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 22: {
                        this.iPv4RemoteASBRID = new IPv4RemoteASBRID(this.getTlv_bytes(), offset);
                        break;
                    }
                    case 1200: {
                        this.availableLabels = new AvailableLabels(this.getTlv_bytes(), offset);
                        break;
                    }
                    default: {
                        LinkTLV.log.warn("Unknown TLV found: " + subTLVType);
                        break;
                    }
                }
            }
            catch (MalformedOSPFSubTLVException e) {
                LinkTLV.log.warn("Malformed SubTLV found ");
                throw new MalformedOSPFTLVException();
            }
            if ((offset += subTLVLength) < this.getTLVValueLength() + 4) continue;
            fin = true;
lbl63:
            // 3 sources

            ** while (!fin)
        }
lbl64:
        // 1 sources

    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public void setLinkType(LinkType linkType) {
        this.linkType = linkType;
    }

    public LinkID getLinkID() {
        return this.linkID;
    }

    public void setLinkID(LinkID linkID) {
        this.linkID = linkID;
    }

    public LocalInterfaceIPAddress getLocalInterfaceIPAddress() {
        return this.localInterfaceIPAddress;
    }

    public void setLocalInterfaceIPAddress(LocalInterfaceIPAddress localInterfaceIPAddress) {
        this.localInterfaceIPAddress = localInterfaceIPAddress;
    }

    public RemoteInterfaceIPAddress getRemoteInterfaceIPAddress() {
        return this.remoteInterfaceIPAddress;
    }

    public void setRemoteInterfaceIPAddress(RemoteInterfaceIPAddress remoteInterfaceIPAddress) {
        this.remoteInterfaceIPAddress = remoteInterfaceIPAddress;
    }

    public MaximumBandwidth getMaximumBandwidth() {
        return this.maximumBandwidth;
    }

    public void setMaximumBandwidth(MaximumBandwidth maximumBandwidth) {
        this.maximumBandwidth = maximumBandwidth;
    }

    public MaximumReservableBandwidth getMaximumReservableBandwidth() {
        return this.maximumReservableBandwidth;
    }

    public void setMaximumReservableBandwidth(MaximumReservableBandwidth maximumReservableBandwidth) {
        this.maximumReservableBandwidth = maximumReservableBandwidth;
    }

    public UnreservedBandwidth getUnreservedBandwidth() {
        return this.unreservedBandwidth;
    }

    public void setUnreservedBandwidth(UnreservedBandwidth unreservedBandwidth) {
        this.unreservedBandwidth = unreservedBandwidth;
    }

    public AvailableLabels getAvailableLabels() {
        return this.availableLabels;
    }

    public void setAvailableLabels(AvailableLabels availableLabels) {
    }

    public AdministrativeGroup getAdministrativeGroup() {
        return this.administrativeGroup;
    }

    public void setAdministrativeGroup(AdministrativeGroup administrativeGroup) {
        this.administrativeGroup = administrativeGroup;
    }

    public TrafficEngineeringMetric getTrafficEngineeringMetric() {
        return this.trafficEngineeringMetric;
    }

    public void setTrafficEngineeringMetric(TrafficEngineeringMetric trafficEngineeringMetric) {
        this.trafficEngineeringMetric = trafficEngineeringMetric;
    }

    public LinkLocalRemoteIdentifiers getLinkLocalRemoteIdentifiers() {
        return this.linkLocalRemoteIdentifiers;
    }

    public void setLinkLocalRemoteIdentifiers(LinkLocalRemoteIdentifiers linkLocalRemoteIdentifiers) {
        this.linkLocalRemoteIdentifiers = linkLocalRemoteIdentifiers;
    }

    public LinkProtectionType getLinkProtectionType() {
        return this.linkProtectionType;
    }

    public void setLinkProtectionType(LinkProtectionType linkProtectionType) {
        this.linkProtectionType = linkProtectionType;
    }

    public SharedRiskLinkGroup getSharedRiskLinkGroup() {
        return this.sharedRiskLinkGroup;
    }

    public void setSharedRiskLinkGroup(SharedRiskLinkGroup sharedRiskLinkGroup) {
    }

    public RemoteASNumber getRemoteASNumber() {
        return this.remoteASNumber;
    }

    public void setRemoteASNumber(RemoteASNumber remoteASNumber) {
    }

    public IPv4RemoteASBRID getIPv4RemoteASBRID() {
        return this.iPv4RemoteASBRID;
    }

    public void setIPv4RemoteASBRID(IPv4RemoteASBRID iPv4RemoteASBRID) {
        this.iPv4RemoteASBRID = iPv4RemoteASBRID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        if (this.linkType != null) {
            sb.append(this.linkType.toString());
            sb.append("\r\n");
        }
        if (this.linkID != null) {
            sb.append(this.linkID.toString());
            sb.append("\r\n");
        }
        if (this.localInterfaceIPAddress != null) {
            sb.append(this.localInterfaceIPAddress.toString());
            sb.append("\r\n");
        }
        if (this.remoteInterfaceIPAddress != null) {
            sb.append(this.remoteInterfaceIPAddress.toString());
            sb.append("\r\n");
        }
        if (this.maximumBandwidth != null) {
            sb.append(this.maximumBandwidth.toString());
            sb.append("\r\n");
        }
        if (this.maximumReservableBandwidth != null) {
            sb.append(this.maximumReservableBandwidth.toString());
            sb.append("\r\n");
        }
        if (this.unreservedBandwidth != null) {
            sb.append(this.unreservedBandwidth.toString());
            sb.append("\r\n");
        }
        if (this.administrativeGroup != null) {
            sb.append(this.administrativeGroup.toString());
            sb.append("\r\n");
        }
        if (this.remoteASNumber != null) {
            sb.append(this.remoteASNumber.toString());
            sb.append("\r\n");
        }
        if (this.iPv4RemoteASBRID != null) {
            sb.append(this.iPv4RemoteASBRID.toString());
            sb.append("\r\n");
        }
        if (this.availableLabels != null) {
            sb.append(this.availableLabels.toString());
            sb.append("\r\n");
        }
        if (this.linkLocalRemoteIdentifiers != null) {
            sb.append(this.linkLocalRemoteIdentifiers.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public String printShort() {
        StringBuffer sb = new StringBuffer(1000);
        if (this.linkID != null) {
            sb.append(this.linkID.toString());
            sb.append("\r\n");
        }
        if (this.localInterfaceIPAddress != null) {
            sb.append(this.localInterfaceIPAddress.toString());
            sb.append("\r\n");
        }
        if (this.remoteInterfaceIPAddress != null) {
            sb.append(this.remoteInterfaceIPAddress.toString());
            sb.append("\r\n");
        }
        if (this.remoteASNumber != null) {
            sb.append(this.remoteASNumber.toString());
            sb.append("\r\n");
        }
        if (this.iPv4RemoteASBRID != null) {
            sb.append(this.iPv4RemoteASBRID.toString());
            sb.append("\r\n");
        }
        if (this.availableLabels != null) {
            sb.append(this.availableLabels.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }
}

