/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa;

import es.tid.ospf.ospfv2.lsa.MalformedOSPFLSAException;
import es.tid.ospf.ospfv2.lsa.OpaqueLSA;
import es.tid.ospf.ospfv2.lsa.tlv.LinkTLV;
import es.tid.ospf.ospfv2.lsa.tlv.MalformedOSPFTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.OSPFTLV;
import es.tid.ospf.ospfv2.lsa.tlv.RouterAddressTLV;

public class OSPFTEv2LSA
extends OpaqueLSA {
    private RouterAddressTLV routerAddressTLV;
    private LinkTLV linkTLV;

    public OSPFTEv2LSA() {
        this.setLStype(10);
        this.setOpaqueType(1);
    }

    public OSPFTEv2LSA(byte[] bytes, int offset) throws MalformedOSPFLSAException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int lsalength = 20;
        if (this.routerAddressTLV != null) {
            this.routerAddressTLV.encode();
            lsalength += this.routerAddressTLV.getTotalTLVLength();
        }
        if (this.linkTLV != null) {
            this.linkTLV.encode();
            lsalength += this.linkTLV.getTotalTLVLength();
        }
        this.setLength(lsalength);
        this.LSAbytes = new byte[this.getLength()];
        this.encodeLSAHeader();
        int offset = 20;
        if (this.routerAddressTLV != null) {
            System.arraycopy(this.routerAddressTLV.getTlv_bytes(), 0, this.LSAbytes, offset, this.routerAddressTLV.getTotalTLVLength());
            offset += this.routerAddressTLV.getTotalTLVLength();
        }
        if (this.linkTLV != null) {
            System.arraycopy(this.linkTLV.getTlv_bytes(), 0, this.LSAbytes, offset, this.linkTLV.getTotalTLVLength());
            offset += this.linkTLV.getTotalTLVLength();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void decode() throws MalformedOSPFLSAException {
        fin = false;
        offset = 20;
        if (this.getLength() != 20) ** GOTO lbl20
        OSPFTEv2LSA.log.warn("Empty LSA");
        throw new MalformedOSPFLSAException();
lbl-1000:
        // 1 sources

        {
            TLVType = OSPFTLV.getType(this.LSAbytes, offset);
            TLVLength = OSPFTLV.getTotalTLVLength(this.LSAbytes, offset);
            try {
                switch (TLVType) {
                    case 1: {
                        this.routerAddressTLV = new RouterAddressTLV(this.LSAbytes, offset);
                        break;
                    }
                    case 2: {
                        this.linkTLV = new LinkTLV(this.LSAbytes, offset);
                    }
                }
            }
            catch (MalformedOSPFTLVException e) {
                throw new MalformedOSPFLSAException();
            }
            if ((offset += TLVLength) < this.getLength()) continue;
            fin = true;
lbl20:
            // 3 sources

            ** while (!fin)
        }
lbl21:
        // 1 sources

    }

    public RouterAddressTLV getRouterAddressTLV() {
        return this.routerAddressTLV;
    }

    public void setRouterAddressTLV(RouterAddressTLV routerAddressTLV) {
        this.routerAddressTLV = routerAddressTLV;
    }

    public LinkTLV getLinkTLV() {
        return this.linkTLV;
    }

    public void setLinkTLV(LinkTLV linkTLV) {
        this.linkTLV = linkTLV;
    }

    public String toString() {
        if (this.routerAddressTLV != null) {
            String string = this.routerAddressTLV.toString();
        }
        String ret = this.linkTLV != null ? this.linkTLV.toString() : "";
        return ret;
    }
}

