/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa;

import es.tid.ospf.ospfv2.lsa.MalformedOSPFLSAException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LSA {
    private int LSage;
    private int options;
    private int LStype;
    private Inet4Address LinkStateId;
    private Inet4Address AdvertisingRouter;
    private int LSsequenceNumber;
    private int checksum;
    private int length;
    protected byte[] LSAbytes;
    protected static final Logger log = LoggerFactory.getLogger((String)"OSPFParser");

    public LSA() {
    }

    public LSA(byte[] bytes, int offset) throws MalformedOSPFLSAException {
        this.LSage = (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
        this.options = bytes[offset + 2] & 0xFF;
        this.LStype = bytes[offset + 3] & 0xFF;
        byte[] ip = new byte[4];
        System.arraycopy(bytes, offset + 4, ip, 0, 4);
        try {
            this.LinkStateId = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            log.warn("ERROR IN Link State ID: " + e.toString());
        }
        System.arraycopy(bytes, offset + 8, ip, 0, 4);
        try {
            this.AdvertisingRouter = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            log.warn("ERROR in Advertising Router: " + e.toString());
        }
        this.LSsequenceNumber = (bytes[offset + 12] & 0xFF) << 24 | (bytes[offset + 13] & 0xFF) << 16 | (bytes[offset + 14] & 0xFF) << 8 | bytes[offset + 15] & 0xFF;
        this.length = (bytes[offset + 18] & 0xFF) << 8 | bytes[offset + 19] & 0xFF;
        this.LSAbytes = new byte[this.length];
        try {
            System.arraycopy(bytes, offset, this.LSAbytes, 0, this.length);
        }
        catch (Exception e) {
            log.warn("ERROR tam de bytes es " + bytes.length);
            throw new MalformedOSPFLSAException();
        }
    }

    public void encodeLSAHeader() {
        this.LSAbytes[0] = (byte)(this.LSage >>> 8);
        this.LSAbytes[1] = (byte)this.LSage;
        this.LSAbytes[2] = (byte)this.options;
        this.LSAbytes[3] = (byte)this.LStype;
        if (this.LinkStateId != null) {
            System.arraycopy(this.LinkStateId.getAddress(), 0, this.LSAbytes, 4, 4);
        }
        if (this.AdvertisingRouter != null) {
            System.arraycopy(this.AdvertisingRouter.getAddress(), 0, this.LSAbytes, 8, 4);
        } else {
            this.LSAbytes[8] = 0;
            this.LSAbytes[9] = 0;
            this.LSAbytes[10] = 0;
            this.LSAbytes[11] = 0;
        }
        this.LSAbytes[12] = (byte)(this.LSsequenceNumber >>> 24);
        this.LSAbytes[13] = (byte)(this.LSsequenceNumber >>> 16);
        this.LSAbytes[14] = (byte)(this.LSsequenceNumber >>> 8);
        this.LSAbytes[15] = (byte)this.LSsequenceNumber;
        this.LSAbytes[16] = 0;
        this.LSAbytes[17] = 0;
        this.LSAbytes[18] = (byte)(this.length >>> 8);
        this.LSAbytes[19] = (byte)this.length;
    }

    public int getLSage() {
        return this.LSage;
    }

    public void setLSage(int lSage) {
        this.LSage = lSage;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public int getLStype() {
        return this.LStype;
    }

    public void setLStype(int lStype) {
        this.LStype = lStype;
    }

    public Inet4Address getLinkStateId() {
        return this.LinkStateId;
    }

    public void setLinkStateId(Inet4Address linkStateId) {
        this.LinkStateId = linkStateId;
    }

    public Inet4Address getAdvertisingRouter() {
        return this.AdvertisingRouter;
    }

    public void setAdvertisingRouter(Inet4Address advertisingRouter) {
        this.AdvertisingRouter = advertisingRouter;
    }

    public int getLSsequenceNumber() {
        return this.LSsequenceNumber;
    }

    public void setLSsequenceNumber(int lSsequenceNumber) {
        this.LSsequenceNumber = lSsequenceNumber;
    }

    public int getLength() {
        return this.length;
    }

    protected void setLength(int length) {
        this.length = length;
    }

    public static int getLStype(byte[] bytes, int offset) {
        return bytes[offset + 3] & 0xFF;
    }

    public static int getLSlength(byte[] bytes, int offset) {
        return (bytes[offset + 18] & 0xFF) << 8 | bytes[offset + 19] & 0xFF;
    }

    public byte[] getLSAbytes() {
        return this.LSAbytes;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public abstract void encode();

    public boolean equals(Object LSAToCompare) {
        LSA other;
        block6: {
            block5: {
                if (LSAToCompare == null) {
                    return false;
                }
                try {
                    other = (LSA)LSAToCompare;
                    if (other.getLStype() == this.getLStype()) break block5;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (other.getLinkStateId().equals(this.getLinkStateId())) break block6;
            return false;
        }
        return other.getAdvertisingRouter().equals(this.getAdvertisingRouter());
    }

    public String printHeader() {
        return "LSType: " + this.getLStype() + " LinkStateId(): " + String.valueOf(this.getLinkStateId()) + " AdvertisingRouter: " + String.valueOf(this.getAdvertisingRouter());
    }
}

