/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2;

import es.tid.ospf.ospfv2.OSPFv2Element;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OSPFv2Packet
implements OSPFv2Element {
    protected static final Logger log = LoggerFactory.getLogger((String)"OSPFParser");
    private int version;
    private int type;
    private int length;
    private Inet4Address routerID;
    private Inet4Address areaID;
    protected byte[] bytes;

    public OSPFv2Packet() {
        this.version = 2;
    }

    public OSPFv2Packet(byte[] bytes, int offset) {
        this.version = bytes[offset] & 0xFF;
        this.type = bytes[offset + 1] & 0xFF;
        this.length = (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
        this.bytes = new byte[this.length];
        byte[] ip = new byte[4];
        System.arraycopy(bytes, offset + 4, ip, 0, 4);
        try {
            this.routerID = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            log.warn("ERROR IN routerID: " + e.toString());
        }
        System.arraycopy(bytes, offset + 8, ip, 0, 4);
        try {
            this.areaID = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            log.warn("ERROR in areaID: " + e.toString());
        }
        System.arraycopy(bytes, offset, this.bytes, 0, this.length);
    }

    public void encodeOSPFV2PacketHeader() {
        this.bytes[0] = (byte)this.version;
        this.bytes[1] = (byte)this.type;
        this.bytes[2] = (byte)(this.length >>> 8);
        this.bytes[3] = (byte)this.length;
        if (this.routerID != null) {
            System.arraycopy(this.routerID.getAddress(), 0, this.bytes, 4, 4);
        } else {
            this.bytes[4] = 0;
            this.bytes[5] = 0;
            this.bytes[6] = 0;
            this.bytes[7] = 0;
            try {
                this.routerID = (Inet4Address)Inet4Address.getByName("0.0.0.0");
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (this.areaID != null) {
            System.arraycopy(this.areaID.getAddress(), 0, this.bytes, 8, 4);
        } else {
            this.bytes[8] = 0;
            this.bytes[9] = 0;
            this.bytes[10] = 0;
            this.bytes[11] = 0;
            try {
                this.areaID = (Inet4Address)Inet4Address.getByName("0.0.0.0");
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        this.bytes[12] = 0;
        this.bytes[13] = 0;
        this.bytes[14] = 0;
        this.bytes[15] = 0;
        this.bytes[16] = 0;
        this.bytes[17] = 0;
        this.bytes[18] = 0;
        this.bytes[19] = 0;
        this.bytes[20] = 0;
        this.bytes[21] = 0;
        this.bytes[22] = 0;
        this.bytes[23] = 0;
    }

    public static int getLStype(byte[] bytes, int offset) {
        return bytes[offset + 1] & 0xFF;
    }

    public static int getLSlength(byte[] bytes, int offset) {
        int length = (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
        return length;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Inet4Address getRouterID() {
        return this.routerID;
    }

    public void setRouterID(Inet4Address routerID) {
        this.routerID = routerID;
    }

    public Inet4Address getAreaID() {
        return this.areaID;
    }

    public void setAreaID(Inet4Address areaID) {
        this.areaID = areaID;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.areaID == null ? 0 : this.areaID.hashCode());
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + this.length;
        result = 31 * result + (this.routerID == null ? 0 : this.routerID.hashCode());
        result = 31 * result + this.type;
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OSPFv2Packet other = (OSPFv2Packet)obj;
        if (this.areaID == null ? other.areaID != null : !this.areaID.equals(other.areaID)) {
            return false;
        }
        if (!Arrays.equals(this.bytes, other.bytes)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.routerID == null ? other.routerID != null : !this.routerID.equals(other.routerID)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.version == other.version;
    }
}

