/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class UndirectionalLinkLossDescriptorSubTLV
extends BGP4TLVFormat {
    int linkLoss;

    public UndirectionalLinkLossDescriptorSubTLV() {
        this.setTLVType(1107);
    }

    public int getLinkLoss() {
        return this.linkLoss;
    }

    public void setLinkLoss(int loss) {
        if (loss < 0) {
            loss = 0;
        }
        if ((double)loss > Math.pow(2.0, 24.0)) {
            loss = (int)(Math.pow(2.0, 24.0) - 1.0);
        }
        this.linkLoss = loss;
    }

    public UndirectionalLinkLossDescriptorSubTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 4;
        this.setTLVValueLength(len);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = 0;
        this.tlv_bytes[offset + 1] = (byte)(this.linkLoss >> 16 & 0xFF);
        this.tlv_bytes[offset + 2] = (byte)(this.linkLoss >> 8 & 0xFF);
        this.tlv_bytes[offset + 3] = (byte)(this.linkLoss & 0xFF);
    }

    public void decode() {
        this.getTLVValueLength();
        int offset = 4;
        this.linkLoss = 0;
        this.linkLoss = this.tlv_bytes[offset + 1] << 16 & 0xFF0000 | this.tlv_bytes[offset + 2] << 8 & 0xFF00 | this.tlv_bytes[offset + 3] & 0xFF;
    }

    public String toString() {
        return "UndirectionalLinkLoss: " + this.linkLoss;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.linkLoss;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UndirectionalLinkLossDescriptorSubTLV other = (UndirectionalLinkLossDescriptorSubTLV)obj;
        return this.linkLoss == other.linkLoss;
    }
}

