/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs;

import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.NodeDescriptorsSubTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class BGPLSIdentifierNodeDescriptorSubTLV
extends NodeDescriptorsSubTLV {
    private Inet4Address BGPLS_ID;

    public BGPLSIdentifierNodeDescriptorSubTLV() {
        this.setSubTLVType(513);
    }

    public BGPLSIdentifierNodeDescriptorSubTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    private void decode() {
        byte[] ip = new byte[4];
        System.arraycopy(this.subtlv_bytes, 4, ip, 0, 4);
        try {
            this.BGPLS_ID = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void encode() {
        this.setSubTLVValueLength(4);
        this.subtlv_bytes = new byte[this.getTotalSubTLVLength()];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.BGPLS_ID.getAddress(), 0, this.subtlv_bytes, offset, 4);
    }

    public Inet4Address getBGPLS_ID() {
        return this.BGPLS_ID;
    }

    public void setBGPLS_ID(Inet4Address bGPLS_ID) {
        this.BGPLS_ID = bGPLS_ID;
    }

    public String toString() {
        return "BGPLS_IDENT [BGPLS_ID=" + String.valueOf(this.BGPLS_ID) + "]";
    }
}

