/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BGP4SubTLV {
    protected int SubTLVType;
    private int SubTLVValueLength;
    protected int TotalSubTLVLength;
    protected byte[] subtlv_bytes;
    protected static final Logger log = LoggerFactory.getLogger((String)"BGP4Parser");

    public BGP4SubTLV() {
    }

    public BGP4SubTLV(byte[] bytes, int offset) {
        this.SubTLVType = (bytes[offset] & 0xFF) << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
        this.SubTLVValueLength = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        this.TotalSubTLVLength = this.SubTLVValueLength + 4;
        this.subtlv_bytes = new byte[this.TotalSubTLVLength];
        System.arraycopy(bytes, offset, this.subtlv_bytes, 0, this.TotalSubTLVLength);
    }

    protected void encodeHeader() {
        this.subtlv_bytes[0] = (byte)(this.SubTLVType >>> 8 & 0xFF);
        this.subtlv_bytes[1] = (byte)(this.SubTLVType & 0xFF);
        this.subtlv_bytes[2] = (byte)(this.SubTLVValueLength >>> 8 & 0xFF);
        this.subtlv_bytes[3] = (byte)(this.SubTLVValueLength & 0xFF);
    }

    public int getSubTLVValueLength() {
        return this.SubTLVValueLength;
    }

    public int getTotalSubTLVLength() {
        return this.TotalSubTLVLength;
    }

    public static int getTotalSubTLVLength(byte[] bytes, int offset) {
        int len = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | (bytes[offset + 3] & 0xFF) + 4;
        return len;
    }

    public static int getSubTLVLength(byte[] bytes, int offset) {
        int len = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        return len;
    }

    public static int getType(byte[] bytes, int offset) {
        int typ = (bytes[offset] & 0xFF) << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
        return typ;
    }

    public int getSubTLVType() {
        return this.SubTLVType;
    }

    protected void setSubTLVType(int subTLVType) {
        this.SubTLVType = subTLVType;
    }

    public byte[] getSubTLV_bytes() {
        return this.subtlv_bytes;
    }

    protected void setSubTLV_bytes(byte[] subtlv_bytes) {
        this.subtlv_bytes = subtlv_bytes;
    }

    protected void setSubTLVValueLength(int SubTLVValueLength) {
        this.SubTLVValueLength = SubTLVValueLength;
        this.TotalSubTLVLength = SubTLVValueLength + 4;
    }

    public abstract void encode();
}

