/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs;

import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.NodeDescriptorsSubTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutonomousSystemNodeDescriptorSubTLV
extends NodeDescriptorsSubTLV {
    private Inet4Address AS_ID;
    private static final Logger log = LoggerFactory.getLogger((String)"BGP4Parser");

    public AutonomousSystemNodeDescriptorSubTLV() {
        this.setSubTLVType(512);
    }

    public AutonomousSystemNodeDescriptorSubTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setSubTLVValueLength(4);
        this.subtlv_bytes = new byte[this.getTotalSubTLVLength()];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.AS_ID.getAddress(), 0, this.subtlv_bytes, offset, 4);
    }

    public void decode() {
        byte[] ip = new byte[4];
        System.arraycopy(this.subtlv_bytes, 4, ip, 0, 4);
        try {
            this.AS_ID = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Inet4Address getAS_ID() {
        return this.AS_ID;
    }

    public void setAS_ID(Inet4Address aS_ID) {
        this.AS_ID = aS_ID;
    }

    public String toString() {
        return "AutonomousSystemSubTLV [AS_ID=" + String.valueOf(this.AS_ID) + "]";
    }
}

