/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import java.util.Arrays;

public class UnreservedBandwidthLinkAttribTLV
extends BGP4TLVFormat {
    public float[] unreservedBandwidth;

    public UnreservedBandwidthLinkAttribTLV() {
        this.setTLVType(1091);
        this.unreservedBandwidth = new float[8];
        this.unreservedBandwidth[0] = 0.0f;
        this.unreservedBandwidth[1] = 0.0f;
        this.unreservedBandwidth[2] = 0.0f;
        this.unreservedBandwidth[3] = 0.0f;
        this.unreservedBandwidth[4] = 0.0f;
        this.unreservedBandwidth[5] = 0.0f;
        this.unreservedBandwidth[6] = 0.0f;
        this.unreservedBandwidth[7] = 0.0f;
    }

    public UnreservedBandwidthLinkAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.unreservedBandwidth = new float[8];
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(32);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        int i = 0;
        while (i < this.unreservedBandwidth.length) {
            int bwi = Float.floatToIntBits(this.unreservedBandwidth[i]);
            this.tlv_bytes[offset] = (byte)(bwi >>> 24);
            this.tlv_bytes[offset + 1] = (byte)(bwi >> 16 & 0xFF);
            this.tlv_bytes[offset + 2] = (byte)(bwi >> 8 & 0xFF);
            this.tlv_bytes[offset + 3] = (byte)(bwi & 0xFF);
            offset += 4;
            ++i;
        }
    }

    protected void decode() {
        int bwi = 0;
        int offset = 4;
        int i = 0;
        while (i < this.unreservedBandwidth.length) {
            bwi = 0;
            int k = 0;
            while (k < 4) {
                bwi = bwi << 8 | this.tlv_bytes[offset + k] & 0xFF;
                ++k;
            }
            this.unreservedBandwidth[i] = Float.intBitsToFloat(bwi);
            offset += 4;
            ++i;
        }
    }

    public String toString() {
        return "UnreservedBandwidthLinkAttribTLV [unreservedBandwidth=" + Arrays.toString(this.unreservedBandwidth) + "]";
    }

    public String toStringShort() {
        String ret = "unrBw[0]: " + this.unreservedBandwidth[0];
        return ret;
    }

    public float[] getUnreservedBandwidth() {
        return this.unreservedBandwidth;
    }

    public void setUnreservedBandwidth(float[] unreservedBandwidth) {
        this.unreservedBandwidth = unreservedBandwidth;
    }
}

