/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class TransceiverClassAndAppAttribTLV
extends BGP4TLVFormat {
    public long trans_app_code;
    public long trans_class;

    public TransceiverClassAndAppAttribTLV() {
        this.setTLVType(2498);
    }

    public TransceiverClassAndAppAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(8);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.trans_app_code >> 24 & 0xFFL);
        this.tlv_bytes[offset + 1] = (byte)(this.trans_app_code >> 16 & 0xFFL);
        this.tlv_bytes[offset + 2] = (byte)(this.trans_app_code >> 8 & 0xFFL);
        this.tlv_bytes[offset + 3] = (byte)(this.trans_app_code & 0xFFL);
        this.tlv_bytes[offset + 4] = (byte)(this.trans_class >> 24 & 0xFFL);
        this.tlv_bytes[offset + 5] = (byte)(this.trans_class >> 16 & 0xFFL);
        this.tlv_bytes[offset + 6] = (byte)(this.trans_class >> 8 & 0xFFL);
        this.tlv_bytes[offset + 7] = (byte)(this.trans_class & 0xFFL);
    }

    protected void decode() {
        int offset = 4;
        log.info("******************* Decodificando TCAA *****************");
        this.trans_app_code = 0L;
        int k = 0;
        while (k < 4) {
            this.trans_app_code = this.trans_app_code << 8 | (long)this.tlv_bytes[k + offset] & 0xFFL;
            ++k;
        }
        offset += 4;
        this.trans_class = 0L;
        k = 0;
        while (k < 4) {
            this.trans_class = this.trans_class << 8 | (long)this.tlv_bytes[k + offset] & 0xFFL;
            ++k;
        }
        log.info("Transceiver Application Code : " + this.trans_app_code + ".");
        log.info("Transceiver Class : " + this.trans_class + ".");
        log.info("***************** FIN Decodificando TCAA ***************");
    }

    public long getTrans_app_code() {
        return this.trans_app_code;
    }

    public void setTrans_app_code(long trans_app_code) {
        this.trans_app_code = trans_app_code;
    }

    public long getTrans_class() {
        return this.trans_class;
    }

    public void setTrans_class(long trans_class) {
        this.trans_class = trans_class;
    }

    public String toString() {
        String str = "<RP Transceiver Application Code: " + this.trans_app_code + " Transceiver Class: " + this.trans_class;
        str = str + ">";
        return str;
    }
}

