/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class SidLabelNodeAttribTLV
extends BGP4TLVFormat {
    private int sid;

    public SidLabelNodeAttribTLV() {
        this.setTLVType(1069);
    }

    public SidLabelNodeAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    private void decode() {
        int k = 0;
        while (k < 4) {
            this.sid = this.sid << 8 | this.tlv_bytes[k + 4] & 0xFF;
            ++k;
        }
    }

    @Override
    public void encode() {
        int len = 4;
        this.setTLVValueLength(len);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        this.tlv_bytes[4] = (byte)(this.sid >>> 24 & 0xFF);
        this.tlv_bytes[5] = (byte)(this.sid >>> 16 & 0xFF);
        this.tlv_bytes[6] = (byte)(this.sid >>> 8 & 0xFF);
        this.tlv_bytes[7] = (byte)(this.sid >>> 0 & 0xFF);
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public String toString() {
        return "SidLabelNodeAttribTLV [SID=" + this.getSid() + "]";
    }
}

