/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import java.util.LinkedList;

public class SharedRiskLinkGroupAttribTLV
extends BGP4TLVFormat {
    public LinkedList<Long> srlg_values;

    public SharedRiskLinkGroupAttribTLV() {
        this.setTLVType(1096);
        this.srlg_values = new LinkedList();
    }

    public SharedRiskLinkGroupAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int offset = 4;
        int i = 0;
        this.setTLVValueLength(this.srlg_values.size() * 4);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        i = 0;
        while (i < this.srlg_values.size()) {
            this.tlv_bytes[offset] = (byte)(this.srlg_values.get(i) >> 24 & 0xFFL);
            this.tlv_bytes[offset + 1] = (byte)(this.srlg_values.get(i) >> 16 & 0xFFL);
            this.tlv_bytes[offset + 2] = (byte)(this.srlg_values.get(i) >> 8 & 0xFFL);
            this.tlv_bytes[offset + 3] = (byte)(this.srlg_values.get(i) & 0xFFL);
            offset += 4;
            ++i;
        }
    }

    protected void decode() {
        int offset = 4;
        int srlg_length = this.getTLVValueLength() / 4;
        this.srlg_values = new LinkedList();
        int i = 0;
        while (i < srlg_length) {
            long srlg_value = 0L;
            int k = 0;
            while (k < 4) {
                srlg_value = srlg_value << 8 | (long)this.tlv_bytes[k + offset] & 0xFFL;
                ++k;
            }
            this.srlg_values.add(new Long(srlg_value));
            offset += 4;
            ++i;
        }
    }

    public LinkedList<Long> getSrlg_values() {
        return this.srlg_values;
    }

    public void setSrlg_values(LinkedList<Long> srlg_values) {
        this.srlg_values = srlg_values;
    }

    public String toString() {
        return "SharedRiskLinkGroupAttribTLV [srlg_values=" + String.valueOf(this.srlg_values) + "]";
    }
}

