/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class RouteTagPrefixAttribTLV
extends BGP4TLVFormat {
    public LinkedList<Inet4Address> routeTags;

    public RouteTagPrefixAttribTLV() {
        this.setTLVType(1153);
        this.routeTags = new LinkedList();
    }

    public RouteTagPrefixAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.routeTags = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        int number = this.routeTags.size();
        this.setTLVValueLength(4 * number);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        int i = 0;
        while (i < number) {
            System.arraycopy(this.routeTags.get(i).getAddress(), 0, this.getTlv_bytes(), offset, 4);
            offset += 4;
            ++i;
        }
    }

    public void decode() {
        int length = this.getTLVValueLength();
        int number = length / 4;
        int offset = 4;
        byte[] address = new byte[4];
        Inet4Address igp_tag = null;
        int i = 0;
        while (i < number) {
            System.arraycopy(this.tlv_bytes, offset, address, 0, 4);
            try {
                igp_tag = (Inet4Address)Inet4Address.getByAddress(address);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            this.routeTags.add(igp_tag);
            offset += 4;
            ++i;
        }
    }

    public LinkedList<Inet4Address> getRouteTags() {
        return this.routeTags;
    }

    public void setRouteTags(LinkedList<Inet4Address> routeTags) {
        this.routeTags = routeTags;
    }

    public String toString() {
        Object ret = "";
        int i = 0;
        while (i < this.routeTags.size()) {
            ret = "ROUTE TAG [" + i + "] IDENTIFIER: " + this.routeTags.get(i).toString();
            ++i;
        }
        return ret;
    }
}

