/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class OSPFForwardingAddressPrefixAttribTLV
extends BGP4TLVFormat {
    Inet4Address OSPFAddress;

    public OSPFForwardingAddressPrefixAttribTLV() {
        this.setTLVType(1156);
    }

    public OSPFForwardingAddressPrefixAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(4);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.OSPFAddress.getAddress(), 0, this.tlv_bytes, 4, 4);
    }

    public void decode() {
        int len = this.getTLVValueLength();
        switch (len) {
            case 4: {
                byte[] ip = new byte[4];
                System.arraycopy(this.tlv_bytes, 4, ip, 0, 4);
                try {
                    this.OSPFAddress = (Inet4Address)Inet4Address.getByAddress(ip);
                    break;
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
        }
        log.debug("IPv6 NOT SUPPORTED YET");
    }

    public Inet4Address getOSPFAddress() {
        return this.OSPFAddress;
    }

    public void setOSPFAddress(Inet4Address oSPFAddress) {
        this.OSPFAddress = oSPFAddress;
    }

    public String toString() {
        return "OSPF ADDRESS [ospf_addr=" + this.OSPFAddress.toString() + "]";
    }
}

