/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import es.tid.protocol.commons.ByteHandler;

public class MetricLinkAttribTLV
extends BGP4TLVFormat {
    private int metric_type;
    private static final int METRIC_TYPE_OSPF = 1;
    private static final int METRIC_TYPE_IS_IS_SHORT = 2;
    private static final int METRIC_TYPE_IS_IS_LONG = 3;
    private int metric;

    public MetricLinkAttribTLV() {
        this.setTLVType(1095);
    }

    public MetricLinkAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int offset = 4;
        if (this.metric_type == 2) {
            this.setTLVValueLength(1);
            this.tlv_bytes = new byte[this.getTotalTLVLength()];
            this.encodeHeader();
            ByteHandler.encode1byteInteger(this.metric, this.getTlv_bytes(), offset);
        } else if (this.metric_type == 1) {
            this.setTLVValueLength(2);
            this.tlv_bytes = new byte[this.getTotalTLVLength()];
            this.encodeHeader();
            ByteHandler.encode2bytesInteger(this.metric, this.getTlv_bytes(), offset);
        } else if (this.metric_type == 3) {
            this.setTLVValueLength(3);
            this.tlv_bytes = new byte[this.getTotalTLVLength()];
            this.encodeHeader();
            ByteHandler.encode3bytesInteger(this.metric, this.getTlv_bytes(), offset);
        } else {
            this.metric_type = 3;
            this.setTLVValueLength(3);
            this.tlv_bytes = new byte[this.getTotalTLVLength()];
            this.encodeHeader();
            this.metric &= 0xFFFFFF;
        }
    }

    public void decode() {
        int length = this.getTLVValueLength();
        switch (length) {
            case 1: {
                this.setMetric_type(2);
                break;
            }
            case 2: {
                this.setMetric_type(1);
                break;
            }
            case 3: {
                this.setMetric_type(3);
                break;
            }
            default: {
                log.debug("No metric tlv defined for this tlv length");
            }
        }
        int offset = 4;
        switch (this.metric_type) {
            case 1: {
                this.setMetric(ByteHandler.decode2bytesInteger(this.getTlv_bytes(), offset));
                break;
            }
            case 2: {
                this.setMetric(ByteHandler.decode1byteInteger(this.getTlv_bytes(), offset));
                break;
            }
            case 3: {
                this.setMetric(ByteHandler.decode3bytesInteger(this.getTlv_bytes(), offset));
                break;
            }
            default: {
                log.debug("This metric type does not exist");
            }
        }
    }

    public int getMetric_type() {
        return this.metric_type;
    }

    public void setMetric_type(int metric_type) {
        this.metric_type = metric_type;
    }

    public int getMetric() {
        return this.metric;
    }

    public void setMetric(int metric) {
        this.metric = metric;
    }

    public String toString() {
        switch (this.metric_type) {
            case 1: {
                return "METRIC [type=" + this.getMetric_type() + ", OSPF METRIC=" + this.getMetric() + "]";
            }
            case 2: {
                return "METRIC [type=" + this.getMetric_type() + ", ISIS SHORT METRIC=" + this.getMetric() + "]";
            }
            case 3: {
                return "METRIC [type=" + this.getMetric_type() + ", ISIS LONG METRIC=" + this.getMetric() + "]";
            }
        }
        return "METRIC [type= UNKWOWN METRIC TYPE]";
    }
}

