/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class MaximumLinkBandwidthLinkAttribTLV
extends BGP4TLVFormat {
    public float maximumBandwidth;

    public MaximumLinkBandwidthLinkAttribTLV() {
        this.setTLVType(1089);
    }

    public MaximumLinkBandwidthLinkAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int bwi = Float.floatToIntBits(this.maximumBandwidth);
        this.tlv_bytes[4] = (byte)(bwi >>> 24);
        this.tlv_bytes[5] = (byte)(bwi >> 16 & 0xFF);
        this.tlv_bytes[6] = (byte)(bwi >> 8 & 0xFF);
        this.tlv_bytes[7] = (byte)(bwi & 0xFF);
    }

    protected void decode() {
        int bwi = 0;
        int k = 0;
        while (k < 4) {
            bwi = bwi << 8 | this.tlv_bytes[k + 4] & 0xFF;
            ++k;
        }
        this.maximumBandwidth = Float.intBitsToFloat(bwi);
    }

    public float getMaximumBandwidth() {
        return this.maximumBandwidth;
    }

    public void setMaximumBandwidth(float maximumBandwidth) {
        this.maximumBandwidth = maximumBandwidth;
    }

    public String toString() {
        return " \t> MaximumBandwidth: " + Float.toString(this.maximumBandwidth);
    }

    public String toStringShort() {
        return "MaxBW: " + Float.toString(this.maximumBandwidth);
    }
}

