/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class IPv4RouterIDLocalNodeLinkAttribTLV
extends BGP4TLVFormat {
    Inet4Address ipv4Address;

    public IPv4RouterIDLocalNodeLinkAttribTLV() {
        this.setTLVType(1028);
    }

    public IPv4RouterIDLocalNodeLinkAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 4;
        this.setTLVValueLength(len);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        System.arraycopy(this.ipv4Address.getAddress(), 0, this.tlv_bytes, 4, 4);
    }

    public void decode() {
        this.getTLVValueLength();
        byte[] ip = new byte[4];
        System.arraycopy(this.tlv_bytes, 4, ip, 0, 4);
        try {
            this.ipv4Address = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Inet4Address getIpv4Address() {
        return this.ipv4Address;
    }

    public void setIpv4Address(Inet4Address ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    public String toString() {
        return "IPv4LocalNodeRouterID [ipv4Address=" + this.ipv4Address.toString() + "]";
    }
}

