/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class AdministrativeGroupLinkAttribTLV
extends BGP4TLVFormat {
    private int administrativeGroup;

    public AdministrativeGroupLinkAttribTLV() {
        this.setTLVType(1088);
        this.administrativeGroup = 0;
    }

    public AdministrativeGroupLinkAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.administrativeGroup >> 24 & 0xFF);
        this.tlv_bytes[offset + 1] = (byte)(this.administrativeGroup >> 16 & 0xFF);
        this.tlv_bytes[offset + 2] = (byte)(this.administrativeGroup >> 8 & 0xFF);
        this.tlv_bytes[offset + 3] = (byte)(this.administrativeGroup & 0xFF);
    }

    protected void decode() {
        int offset = 4;
        this.administrativeGroup = (this.tlv_bytes[offset] & 0xFF) << 24 | (this.tlv_bytes[offset + 1] & 0xFF) << 16 | (this.tlv_bytes[offset + 2] & 0xFF) << 8 | this.tlv_bytes[offset + 3] & 0xFF;
    }

    public int getAdministrativeGroup() {
        return this.administrativeGroup;
    }

    public void setAdministrativeGroup(int administrativeGroup) {
        this.administrativeGroup = administrativeGroup;
    }

    public boolean isGroup(int groupNumber) {
        return this.administrativeGroup >>> groupNumber == 1;
    }

    public void setGroup(int groupNumber) {
        this.administrativeGroup |= 1 << groupNumber;
    }

    public String toString() {
        return "ADMINISTRATIVE GROUP [Administrative Group =" + Integer.toBinaryString(this.administrativeGroup) + "]";
    }
}

