/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.complexFields;

import es.tid.bgp.bgp4.update.tlv.complexFields.LabelSetField;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;

public class BitmapLabelSet
extends LabelSetField {
    private byte[] bytesBitmap;
    private byte[] bytesBitmapReserved;
    private int sumBytesBitmap;
    private DWDMWavelengthLabel dwdmWavelengthLabel;

    public BitmapLabelSet() {
        this.action = 4;
    }

    public BitmapLabelSet(byte[] bytes, int offset) {
        this.length = bytes[offset + 2] << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        this.bytes = new byte[this.length];
        System.arraycopy(bytes, offset, this.bytes, 0, this.length);
        this.dwdmWavelengthLabel = new DWDMWavelengthLabel();
        this.decodeHeader();
        this.decode();
    }

    public BitmapLabelSet(byte[] bytesBitMap) {
    }

    @Override
    public void encode() {
        int offset = 4;
        int numberBytes = this.getNumberBytes(this.numLabels);
        try {
            this.dwdmWavelengthLabel.encode();
        }
        catch (RSVPProtocolViolationException e) {
            e.printStackTrace();
        }
        int size_bytes = 8 + numberBytes;
        if (size_bytes % 4 != 0) {
            size_bytes += 4 - size_bytes % 4;
        }
        this.setLength(size_bytes);
        this.bytes = new byte[size_bytes];
        this.encodeHeader();
        System.arraycopy(this.dwdmWavelengthLabel.getBytes(), 0, this.bytes, offset, 4);
        System.arraycopy(this.bytesBitmap, 0, this.bytes, offset += 4, numberBytes);
        int i = offset += numberBytes;
        while (i < size_bytes) {
            this.bytes[i] = 0;
            ++i;
        }
    }

    @Override
    public void decode() {
        int offset = 4;
        try {
            this.dwdmWavelengthLabel.decode(this.bytes, offset);
        }
        catch (RSVPProtocolViolationException e) {
            e.printStackTrace();
        }
        int numberBytes = this.getNumberBytes(this.numLabels);
        this.bytesBitmap = new byte[numberBytes];
        System.arraycopy(this.bytes, offset += 4, this.bytesBitmap, 0, numberBytes);
        this.createBytesBitMapRes(this.bytesBitmap);
    }

    public byte[] getBytesBitmapReserved() {
        return this.bytesBitmapReserved;
    }

    public DWDMWavelengthLabel getDwdmWavelengthLabel() {
        return this.dwdmWavelengthLabel;
    }

    public void setBytesBitmapReserved(byte[] bytesBitmapReserved) {
        this.bytesBitmapReserved = bytesBitmapReserved;
    }

    public void setDwdmWavelengthLabel(DWDMWavelengthLabel dwdmWavelengthLabel) {
        this.dwdmWavelengthLabel = dwdmWavelengthLabel;
    }

    public byte[] getBytesBitMap() {
        return this.bytesBitmap;
    }

    public void createBytesBitMap(byte[] bytesBitMap) {
        this.bytesBitmap = new byte[bytesBitMap.length];
        System.arraycopy(bytesBitMap, 0, this.bytesBitmap, 0, bytesBitMap.length);
    }

    public void arraycopyBytesBitMap(byte[] bytesBitMap) {
        System.arraycopy(bytesBitMap, 0, this.bytesBitmap, 0, bytesBitMap.length);
    }

    public void arraycopyBytesBitMap(byte[] bytesBitMap, int lambdaIni, int lambdaEnd) {
        System.arraycopy(bytesBitMap, lambdaIni, this.bytesBitmap, lambdaIni, lambdaEnd - lambdaIni);
    }

    public void createBytesBitMapRes(byte[] bytesBitMapRes) {
        this.bytesBitmapReserved = new byte[bytesBitMapRes.length];
        System.arraycopy(bytesBitMapRes, 0, this.bytesBitmapReserved, 0, bytesBitMapRes.length);
    }

    public void setBytesBitmap(byte[] bytesBitmap) {
        this.bytesBitmap = bytesBitmap;
    }

    private boolean equalsBytes(byte[] bytes1, byte[] bytes2) {
        int i = 0;
        while (i < bytes1.length) {
            if ((bytes1[i] | bytes2[i]) != bytes1[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getNumberBytes() {
        return this.bytesBitmap.length;
    }

    public int getNumberBytes(int num) {
        int numberBytes = num / 8;
        if (numberBytes * 8 < num) {
            ++numberBytes;
        }
        return numberBytes;
    }

    public boolean equals(Object obj) {
        if (this.dwdmWavelengthLabel.equals(((BitmapLabelSet)obj).getDwdmWavelengthLabel())) {
            return this.equalsBytes(this.bytesBitmap, ((BitmapLabelSet)obj).getBytesBitMap());
        }
        return false;
    }

    @Override
    public String toString() {
        Object ret = "";
        if (this.dwdmWavelengthLabel != null) {
            ret = (String)ret + "n: " + String.valueOf(this.dwdmWavelengthLabel.getN()) + "\r\n";
        }
        ret = (String)ret + "Bytes Bitmap: ";
        int i = 0;
        while (i < this.bytesBitmap.length) {
            ret = (this.bytesBitmap[i] & 0xFF) <= 15 ? (String)ret + "0" + Integer.toHexString(this.bytesBitmap[i] & 0xFF) : (String)ret + Integer.toHexString(this.bytesBitmap[i] & 0xFF);
            ++i;
        }
        ret = (String)ret + "\r\n";
        ret = (String)ret + "Bytes Reserved Bitmap: ";
        i = 0;
        while (i < this.bytesBitmapReserved.length) {
            ret = (this.bytesBitmapReserved[i] & 0xFF) <= 15 ? (String)ret + "0" + Integer.toHexString(this.bytesBitmapReserved[i] & 0xFF) : (String)ret + Integer.toHexString(this.bytesBitmapReserved[i] & 0xFF);
            ++i;
        }
        ret = (String)ret + "\r\n";
        return ret;
    }

    public int getSumaBits() {
        this.sumBytesBitmap = 0;
        int i = 0;
        while (i < this.bytesBitmap.length * 8) {
            if ((this.bytesBitmap[i / 8] & 128 >> i % 8) == 128 >> i % 8) {
                ++this.sumBytesBitmap;
            }
            ++i;
        }
        return this.sumBytesBitmap;
    }

    public BitmapLabelSet duplicate() {
        BitmapLabelSet bls = new BitmapLabelSet();
        bls.setBytesBitmap((byte[])this.bytesBitmapReserved.clone());
        bls.createBytesBitMapRes(bls.getBytesBitMap());
        bls.setDwdmWavelengthLabel(this.getDwdmWavelengthLabel().duplicate());
        return bls;
    }
}

